/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ValueConstraintsValidator {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ValueConstraintsValidator");
    protected static final String DEFAULT_THRESHOLD = "";
    protected final String[] constraints;

    public ValueConstraintsValidator(String[] constraints) {
        this.constraints = constraints;
    }

    protected MinMaxConstraint parseAsMinMax(String constraint) throws ConstraintViolationException {
        String[] parts = constraint.split(",");
        if (parts.length != 2) {
            throw new ConstraintViolationException("Value constraint '" + constraint + "' is invalid accrding the JSR-170 spec.");
        }
        boolean exclusive = false;
        if (parts[0].startsWith("(")) {
            exclusive = true;
        } else if (parts[0].startsWith("[")) {
            exclusive = false;
        } else {
            throw new ConstraintViolationException("Value constraint '" + constraint + "' min exclusion rule is unefined accrding the JSR-170 spec.");
        }
        ConstraintRange minValue = new ConstraintRange(parts[0].length() > 1 ? parts[0].substring(1) : DEFAULT_THRESHOLD, exclusive);
        if (parts[1].endsWith(")")) {
            exclusive = true;
        } else if (parts[1].endsWith("]")) {
            exclusive = false;
        } else {
            throw new ConstraintViolationException("Value constraint '" + constraint + "' max exclusion rule is unefined accrding the JSR-170 spec.");
        }
        ConstraintRange maxValue = new ConstraintRange(parts[1].length() > 1 ? parts[1].substring(0, parts[1].length() - 1) : DEFAULT_THRESHOLD, exclusive);
        return new MinMaxConstraint(minValue, maxValue);
    }

    public void validateFor(int type) throws ValueFormatException {
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (this.constraints == null || this.constraints.length <= 0) {
                            return;
                        }
                        if (type != 5) break block17;
                        for (String constrString : this.constraints) {
                            try {
                                MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                                if (constraint.getMin().getThreshold().length() > 0) {
                                    JCRDateFormat.parse(constraint.getMin().getThreshold());
                                }
                                if (constraint.getMax().getThreshold().length() <= 0) continue;
                                JCRDateFormat.parse(constraint.getMax().getThreshold());
                            }
                            catch (ValueFormatException e) {
                                throw new ValueFormatException("Wrong DATE constraint format " + constrString, (Throwable)e);
                            }
                            catch (ConstraintViolationException e) {
                                throw new ValueFormatException("Wrong DATE constraint format " + constrString, (Throwable)e);
                            }
                        }
                        break block18;
                    }
                    if (type != 4) break block19;
                    for (String constrString : this.constraints) {
                        try {
                            MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                            if (constraint.getMin().getThreshold().length() > 0) {
                                Double.parseDouble(constraint.getMin().getThreshold());
                            }
                            if (constraint.getMax().getThreshold().length() <= 0) continue;
                            Double.parseDouble(constraint.getMax().getThreshold());
                        }
                        catch (NumberFormatException e) {
                            throw new ValueFormatException("Wrong DOUBLE constraint format " + constrString, (Throwable)e);
                        }
                        catch (ConstraintViolationException e) {
                            throw new ValueFormatException("Wrong DOUBLE constraint format " + constrString, (Throwable)e);
                        }
                    }
                    break block18;
                }
                if (type != 3 && type != 2) break block20;
                for (String constrString : this.constraints) {
                    try {
                        MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                        if (constraint.getMin().getThreshold().length() > 0) {
                            Long.parseLong(constraint.getMin().getThreshold());
                        }
                        if (constraint.getMax().getThreshold().length() <= 0) continue;
                        Long.parseLong(constraint.getMax().getThreshold());
                    }
                    catch (NumberFormatException e) {
                        throw new ValueFormatException("Wrong LONG (or BINARY size) constraint format " + constrString, (Throwable)e);
                    }
                    catch (ConstraintViolationException e) {
                        throw new ValueFormatException("Wrong LONG (or BINARY size) constraint format " + constrString, (Throwable)e);
                    }
                }
                break block18;
            }
            if (type != 6) break block18;
            for (String constrString : this.constraints) {
                if (constrString.equalsIgnoreCase("true") || constrString.equalsIgnoreCase("false")) continue;
                throw new ValueFormatException("Wrong BOOLEAN constraint format: " + constrString);
            }
        }
    }

    protected class ConstraintRange {
        private final String value;
        private final boolean exclusive;

        public ConstraintRange(String value) {
            this.value = value;
            this.exclusive = false;
        }

        public ConstraintRange(String value, boolean exclusive) {
            this.value = value;
            this.exclusive = exclusive;
        }

        protected String getThreshold() {
            return this.value;
        }

        protected boolean isExclusive() {
            return this.exclusive;
        }
    }

    protected class MinMaxConstraint {
        private final ConstraintRange minValue;
        private final ConstraintRange maxValue;

        public MinMaxConstraint(ConstraintRange minValue, ConstraintRange maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        protected ConstraintRange getMax() {
            return this.maxValue;
        }

        protected ConstraintRange getMin() {
            return this.minValue;
        }
    }
}

