/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class WriteValue
extends ValueFileOperation {
    protected final File file;
    protected final ValueData value;
    protected ValueFileOperation.ValueFileLock fileLock;
    protected final ChangedSizeHandler sizeHandler;

    public WriteValue(File file, ValueData value, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir, ChangedSizeHandler sizeHandler) {
        super(resources, cleaner, tempDir);
        this.file = file;
        this.value = value;
        this.sizeHandler = sizeHandler;
    }

    @Override
    public void execute() throws IOException {
        this.makePerformed();
        this.fileLock = new ValueFileOperation.ValueFileLock(this.file);
        this.fileLock.lock();
    }

    @Override
    public void prepare() throws IOException {
        if (this.fileLock != null) {
            this.file.getParentFile().mkdirs();
            if (this.file.exists()) {
                this.cleaner.removeFile(this.file);
            }
            long contentSize = this.writeValue(this.file, this.value);
            this.sizeHandler.accumulateNewSize(contentSize);
        }
    }

    @Override
    public void rollback() throws IOException {
        if (this.fileLock != null) {
            try {
                if (this.file.exists() && !this.file.delete()) {
                    this.cleaner.addFile(this.file);
                }
            }
            finally {
                this.fileLock.unlock();
            }
        }
    }

    @Override
    public void twoPhaseCommit() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.unlock();
        }
    }
}

