/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsTargetObject;
import org.exoplatform.news.rest.NewsTargetingEntity;
import org.exoplatform.news.rest.NewsTargetingPermissionsEntity;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public class NewsTargetingServiceImpl
implements NewsTargetingService {
    private static final Log LOG = ExoLogger.getLogger(NewsTargetingServiceImpl.class);
    private static final String SPACE_TARGET_PERMISSION_PREFIX = "space:";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private MetadataService metadataService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private OrganizationService organizationService;

    public NewsTargetingServiceImpl(MetadataService metadataService, IdentityManager identityManager, SpaceService spaceService, OrganizationService organizationService) {
        this.metadataService = metadataService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.organizationService = organizationService;
    }

    @Override
    public List<NewsTargetingEntity> getAllTargets() {
        List targets = this.metadataService.getMetadatas(METADATA_TYPE.getName(), 0L);
        return targets.stream().map(this::toEntity).toList();
    }

    @Override
    public List<NewsTargetingEntity> getAllowedTargets(Identity userIdentity) {
        List allTargetsMetadatas = this.metadataService.getMetadatas(METADATA_TYPE.getName(), 0L);
        return allTargetsMetadatas.stream().filter(targetMetadata -> targetMetadata.getProperties().get("permissions") != null && List.of(((String)targetMetadata.getProperties().get("permissions")).split(",")).stream().anyMatch(targetMetadataPermission -> {
            if (targetMetadataPermission.contains(SPACE_TARGET_PERMISSION_PREFIX)) {
                if (targetMetadataPermission.split(SPACE_TARGET_PERMISSION_PREFIX).length > 1) {
                    Space targetPermissionSpace = this.spaceService.getSpaceById(targetMetadataPermission.split(SPACE_TARGET_PERMISSION_PREFIX)[1]);
                    return targetPermissionSpace != null && this.spaceService.isPublisher(targetPermissionSpace, userIdentity.getUserId());
                }
                return false;
            }
            try {
                Group targetPermissionGroup = this.organizationService.getGroupHandler().findGroupById(targetMetadataPermission);
                return targetPermissionGroup != null && userIdentity.isMemberOf(targetMetadataPermission, PUBLISHER_MEMBERSHIP_NAME);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not find group from permission " + targetMetadataPermission));
                return false;
            }
        })).map(this::toEntity).toList();
    }

    @Override
    public void deleteTargetByName(String targetName, Identity currentIdentity) throws IllegalAccessException {
        if (currentIdentity != null && !NewsUtils.canManageNewsPublishTargets(currentIdentity)) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " not authorized to delete news target with name " + targetName);
        }
        MetadataKey targetMetadataKey = new MetadataKey(METADATA_TYPE.getName(), targetName, 0L);
        Metadata targetMetadata = this.metadataService.getMetadataByKey(targetMetadataKey);
        this.metadataService.deleteMetadataById(targetMetadata.getId());
    }

    @Override
    public List<String> getTargetsByNewsId(String newsId) {
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", newsId, null);
        List newsTargets = this.metadataService.getMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), (MetadataObject)newsTargetObject);
        return newsTargets.stream().map(MetadataItem::getMetadata).map(Metadata::getName).toList();
    }

    @Override
    public void saveNewsTarget(News news, boolean displayed, List<String> targets, String currentUserId) throws IllegalAccessException {
        Identity currentIdentity = NewsUtils.getUserIdentity(currentUserId);
        if (!NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity)) {
            throw new IllegalAccessException("User " + currentUserId + " not authorized to save news targets");
        }
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", news.getId(), null);
        org.exoplatform.social.core.identity.model.Identity currentSocIdentity = this.identityManager.getOrCreateIdentity("organization", currentUserId);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("displayed", String.valueOf(displayed));
        targets.stream().forEach(targetName -> {
            try {
                MetadataKey metadataKey = new MetadataKey(NewsTargetingService.METADATA_TYPE.getName(), targetName, 0L);
                this.metadataService.createMetadataItem((MetadataObject)newsTargetObject, metadataKey, properties, Long.parseLong(currentSocIdentity.getId()));
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.warn("Targets with name {} is already associated to object {}. Ignore error since it will not affect result.", new Object[]{targetName, newsTargetObject, e});
            }
        });
    }

    @Override
    public List<MetadataItem> getNewsTargetItemsByTargetName(String targetName, long offset, long limit) {
        return this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(targetName, METADATA_TYPE.getName(), "news", "displayed", String.valueOf(true), offset, limit);
    }

    @Override
    public void deleteNewsTargets(String newsId) {
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", newsId, null);
        this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), (MetadataObject)newsTargetObject);
    }

    @Override
    public void deleteNewsTargets(News news, String currentUserId) throws IllegalAccessException {
        Identity currentIdentity = NewsUtils.getUserIdentity(currentUserId);
        if (!NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to delete news targets");
        }
        this.deleteNewsTargets(news.getId());
    }

    @Override
    public Metadata createNewsTarget(NewsTargetingEntity newsTargetingEntity, Identity currentIdentity) throws IllegalArgumentException, IllegalAccessException {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
        long userIdentityId = identity == null ? 0L : Long.parseLong(identity.getId());
        Metadata metadata = this.fromEntity(newsTargetingEntity);
        metadata.setCreatorId(userIdentityId);
        if (!NewsUtils.canManageNewsPublishTargets(currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to create news targets");
        }
        MetadataKey targetMetadataKey = new MetadataKey(METADATA_TYPE.getName(), metadata.getName(), 0L);
        Metadata storedMetadata = this.metadataService.getMetadataByKey(targetMetadataKey);
        if (storedMetadata != null) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " not authorized to create news target with same name " + metadata.getName());
        }
        return this.metadataService.createMetadata(metadata, userIdentityId);
    }

    @Override
    public Metadata updateNewsTargets(String originalTargetName, NewsTargetingEntity newsTargetingEntity, Identity currentIdentity) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        boolean isSameDescription;
        if (!NewsUtils.canManageNewsPublishTargets(currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to get news targets");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
        long userIdentityId = identity == null ? 0L : Long.parseLong(identity.getId());
        MetadataKey targetMetadataKey = new MetadataKey(METADATA_TYPE.getName(), originalTargetName, 0L);
        Metadata storedMetadata = this.metadataService.getMetadataByKey(targetMetadataKey);
        if (storedMetadata == null) {
            throw new IllegalStateException("User " + currentIdentity.getUserId() + " can not get news target with this name " + originalTargetName);
        }
        boolean isSameName = StringUtils.equals((CharSequence)newsTargetingEntity.getName(), (CharSequence)originalTargetName);
        if (!isSameName) {
            storedMetadata.setName(newsTargetingEntity.getName());
        }
        if (!(isSameDescription = newsTargetingEntity.getProperties().entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(storedMetadata.getProperties().get(e.getKey()))))) {
            storedMetadata.setProperties(newsTargetingEntity.getProperties());
        }
        if (isSameName && isSameDescription) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " don't make any changes");
        }
        return this.metadataService.updateMetadata(storedMetadata, userIdentityId);
    }

    private NewsTargetingEntity toEntity(Metadata metadata) {
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName(metadata.getName());
        if (metadata.getProperties() != null) {
            newsTargetingEntity.setProperties(metadata.getProperties());
        }
        if (newsTargetingEntity.getProperties().get("permissions") != null) {
            String permissions = newsTargetingEntity.getProperties().get("permissions");
            List<String> permissionsList = List.of(permissions.split(","));
            ArrayList<NewsTargetingPermissionsEntity> permissionsEntities = new ArrayList<NewsTargetingPermissionsEntity>();
            for (String permission : permissionsList) {
                NewsTargetingPermissionsEntity permissionEntity = new NewsTargetingPermissionsEntity();
                if (permission.contains(SPACE_TARGET_PERMISSION_PREFIX)) {
                    Space space;
                    if (permission.split(SPACE_TARGET_PERMISSION_PREFIX).length > 1 && (space = this.spaceService.getSpaceById(permission.split(SPACE_TARGET_PERMISSION_PREFIX)[1])) != null) {
                        permissionEntity.setId(SPACE_TARGET_PERMISSION_PREFIX + space.getId());
                        permissionEntity.setName(space.getDisplayName());
                        permissionEntity.setProviderId("space");
                        permissionEntity.setRemoteId(space.getPrettyName());
                        permissionEntity.setAvatar(space.getAvatarUrl());
                    }
                } else {
                    try {
                        Group group = this.organizationService.getGroupHandler().findGroupById(permission);
                        if (group != null) {
                            permissionEntity.setId(group.getId());
                            permissionEntity.setName(group.getLabel());
                            permissionEntity.setProviderId("group");
                            permissionEntity.setRemoteId(group.getGroupName());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not find group from permission" + permission));
                    }
                }
                if (permissionEntity.getId() == null) continue;
                permissionsEntities.add(permissionEntity);
            }
            newsTargetingEntity.setPermissions(permissionsEntities);
        }
        return newsTargetingEntity;
    }

    private Metadata fromEntity(NewsTargetingEntity newsTargetingEntity) {
        Metadata metadata = new Metadata();
        metadata.setName(newsTargetingEntity.getName());
        metadata.setAudienceId(0L);
        metadata.setType(METADATA_TYPE);
        metadata.setProperties(newsTargetingEntity.getProperties());
        metadata.setCreatorId(0L);
        return metadata;
    }
}

