/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.jpa.storage.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.jpa.EditorConfigStorage;
import org.exoplatform.onlyoffice.jpa.storage.impl.RDBMSEditorConfigStorageImpl;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CachedEditorConfigStorage
implements EditorConfigStorage {
    private EditorConfigStorage storage;
    private final ExoCache<String, Map<String, Config>> configCache;
    public static final String CACHE_NAME = "onlyoffice.EditorCache";

    public CachedEditorConfigStorage(RDBMSEditorConfigStorageImpl storage, CacheService cacheService) {
        this.storage = storage;
        this.configCache = cacheService.getCacheInstance(CACHE_NAME);
    }

    @Override
    public Map<String, Config> getConfigsByKey(String key) {
        Map<String, Config> configs = (Map<String, Config>)this.configCache.get((Serializable)((Object)key));
        if (configs != null) {
            return configs;
        }
        configs = this.storage.getConfigsByKey(key);
        if (configs != null && !configs.isEmpty()) {
            this.configCache.put((Serializable)((Object)key), configs);
        }
        return configs;
    }

    @Override
    public Map<String, Config> getConfigsByDocId(String docId) {
        Map<String, Config> configs = (Map<String, Config>)this.configCache.get((Serializable)((Object)docId));
        if (configs != null) {
            return configs;
        }
        configs = this.storage.getConfigsByDocId(docId);
        if (configs != null && !configs.isEmpty()) {
            this.configCache.put((Serializable)((Object)docId), configs);
        }
        return configs;
    }

    @Override
    public void saveConfig(String key, Config config, boolean isNew) {
        this.storage.saveConfig(key, config, isNew);
        this.configCache.remove((Serializable)((Object)key));
    }

    @Override
    public void saveConfig(List<String> keys, Config config, boolean isNew) {
        this.storage.saveConfig(keys, config, isNew);
        keys.forEach(arg_0 -> this.configCache.remove(arg_0));
    }

    @Override
    public void deleteConfig(String key, Config config) {
        this.storage.deleteConfig(key, config);
        this.configCache.remove((Serializable)((Object)key));
    }

    @Override
    public void deleteConfig(List<String> keys, Config config) {
        this.storage.deleteConfig(keys, config);
        keys.forEach(arg_0 -> this.configCache.remove(arg_0));
    }
}

