/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.cometd.CometdConfig;
import org.exoplatform.onlyoffice.cometd.CometdOnlyofficeService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class OnlyofficeContext {
    public static final String USERID_ATTRIBUTE = "OnlyofficeContext.userId";
    public static final String DOCUMENT_WORKSPACE_ATTRIBUTE = "OnlyofficeContext.document.workspace";
    public static final String DOCUMENT_PATH_ATTRIBUTE = "OnlyofficeContext.document.path";
    protected static final String JAVASCRIPT = "OnlyofficeContext_Javascript".intern();
    protected static final String CLIENT_RESOURCE_PREFIX = "OnlyofficeEditorClient.";
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeContext.class);
    private final RequireJS require;

    private OnlyofficeContext(WebuiRequestContext requestContext) throws Exception {
        String messagesJson;
        JavascriptManager js = requestContext.getJavascriptManager();
        this.require = js.require("SHARED/onlyoffice", "onlyoffice");
        try {
            ResourceBundleService i18nService = (ResourceBundleService)requestContext.getApplication().getApplicationServiceContainer().getComponentInstanceOfType(ResourceBundleService.class);
            ResourceBundle res = i18nService.getResourceBundle("locale.onlyoffice.OnlyofficeClient", requestContext.getLocale());
            HashMap<String, String> resMap = new HashMap<String, String>();
            Enumeration<String> keys = res.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String bundleKey = key.startsWith(CLIENT_RESOURCE_PREFIX) ? key.substring(CLIENT_RESOURCE_PREFIX.length()) : key;
                resMap.put(bundleKey, res.getString(key));
            }
            messagesJson = new JsonGeneratorImpl().createJsonObjectFromMap(resMap).toString();
        }
        catch (JsonException e) {
            LOG.warn((Object)"Cannot serialize messages bundle JSON", (Throwable)e);
            messagesJson = "{}";
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot build messages bundle", (Throwable)e);
            messagesJson = "{}";
        }
        ConversationState convo = ConversationState.getCurrent();
        if (convo == null || convo.getIdentity() == null) {
            throw new OnlyofficeEditorException("Authenticated user required");
        }
        ExoContainer container = requestContext.getApplication().getApplicationServiceContainer();
        CometdOnlyofficeService cometdService = (CometdOnlyofficeService)container.getComponentInstanceOfType(CometdOnlyofficeService.class);
        String userId = convo.getIdentity().getUserId();
        CometdConfig cometdConf = new CometdConfig(cometdService.getCometdServerPath(), cometdService.getUserToken(userId), PortalContainer.getCurrentPortalContainerName());
        this.callOnModule("init('" + userId + "', " + cometdConf.toJSON() + ", " + messagesJson + ");");
    }

    private RequireJS appRequireJS() {
        return this.require;
    }

    private void callOnModule(String code) {
        this.require.addScripts("onlyoffice." + code + "\n");
    }

    private void showClientError(String title, String message) {
        this.callOnModule("showError('" + title + ("', '" + message + "');"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OnlyofficeContext context() throws Exception {
        OnlyofficeContext context;
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj == null || !OnlyofficeContext.class.isAssignableFrom(obj.getClass())) {
            WebuiRequestContext webuiRequestContext = requestContext;
            synchronized (webuiRequestContext) {
                obj = requestContext.getAttribute(JAVASCRIPT);
                if (obj == null || !OnlyofficeContext.class.isAssignableFrom(obj.getClass())) {
                    context = new OnlyofficeContext(requestContext);
                    requestContext.setAttribute(JAVASCRIPT, (Object)context);
                } else {
                    context = (OnlyofficeContext)OnlyofficeContext.class.cast(obj);
                }
            }
        } else {
            context = (OnlyofficeContext)OnlyofficeContext.class.cast(obj);
        }
        return context;
    }

    public static void init() throws Exception {
        OnlyofficeContext.context();
    }

    public static void callModule(String code) throws Exception {
        OnlyofficeContext.context().callOnModule(code);
    }

    public static RequireJS requireJS() throws Exception {
        return OnlyofficeContext.context().appRequireJS();
    }

    public static void showError(String title, String message) {
        try {
            OnlyofficeContext.context().showClientError(title, message);
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing context", (Throwable)e);
        }
    }
}

