/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationStore;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeManager;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeStore;
import org.exoplatform.portal.mop.navigation.Scope;

public class JDBCNavigationServiceImpl
implements NavigationService {
    private final NodeManager manager;
    final NavigationStore store;

    public JDBCNavigationServiceImpl(NavigationStore store) throws NullPointerException {
        if (store == null) {
            throw new NullPointerException("No null persistence factory allowed");
        }
        this.store = store;
        this.manager = new NodeManager((NodeStore)store);
    }

    public NavigationContext loadNavigation(SiteKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        NavigationData data = this.store.loadNavigationData(key);
        return data != null && data != NavigationData.EMPTY ? new NavigationContext(data) : null;
    }

    public List<NavigationContext> loadNavigations(SiteType type) throws NullPointerException, NavigationServiceException {
        if (type == null) {
            throw new NullPointerException();
        }
        LinkedList<NavigationContext> navigations = new LinkedList<NavigationContext>();
        for (NavigationData data : this.store.loadNavigations(type)) {
            navigations.add(new NavigationContext(data));
        }
        return navigations;
    }

    public void saveNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        if (navigation == null) {
            throw new NullPointerException();
        }
        try {
            this.store.saveNavigation(navigation.key, navigation.getState());
            navigation.data = this.store.loadNavigationData(navigation.key);
            navigation.state = null;
        }
        finally {
            this.store.flush();
        }
    }

    public boolean destroyNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        if (navigation == null) {
            throw new NullPointerException("No null navigation argument");
        }
        if (navigation.data == null) {
            throw new IllegalArgumentException("Already removed");
        }
        try {
            if (this.store.destroyNavigation(navigation.data)) {
                navigation.data = null;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.store.flush();
        }
    }

    public <N> NodeContext<N> loadNode(NodeModel<N> model, NavigationContext navigation, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        if (model == null) {
            throw new NullPointerException("No null model accepted");
        }
        if (navigation == null) {
            throw new NullPointerException("No null navigation accepted");
        }
        if (scope == null) {
            throw new NullPointerException("No null scope accepted");
        }
        String nodeId = navigation.data.rootId;
        if (navigation.data.rootId != null) {
            return this.manager.loadNode(model, nodeId, scope, listener);
        }
        return null;
    }

    public <N> NodeContext<N> loadNodeById(NodeModel<N> model, String nodeId, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        if (model == null) {
            throw new NullPointerException("No null model accepted");
        }
        if (nodeId == null) {
            throw new NullPointerException("No null node id accepted");
        }
        if (scope == null) {
            throw new NullPointerException("No null scope accepted");
        }
        return this.manager.loadNode(model, nodeId, scope, listener);
    }

    public <N> void updateNode(NodeContext<N> root, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, IllegalArgumentException, NavigationServiceException {
        this.manager.updateNode(root, scope, listener);
    }

    public <N> void saveNode(NodeContext<N> context, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        this.manager.saveNode(context, listener);
    }

    public <N> void rebaseNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NavigationServiceException {
        this.manager.rebaseNode(context, scope, listener);
    }
}

