/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.notification;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.wallet.reward.notification.RewardSuccessTemplateBuilder;
import org.exoplatform.wallet.reward.service.RewardSettingsService;

public class RewardSuccessTemplateProvider
extends TemplateProvider {
    private static final PluginKey PLUGIN_KEY = PluginKey.key((String)"RewardSuccessNotificationPlugin");
    private RewardSuccessTemplateBuilder builder = null;
    private String webTemplatePath = null;
    private String pushTemplatePath = null;
    private String mailTemplatePath = null;

    public RewardSuccessTemplateProvider(PortalContainer container, RewardSettingsService rewardSettingsService, InitParams initParams) {
        super(initParams);
        this.builder = new RewardSuccessTemplateBuilder(container, rewardSettingsService, this.getChannelKey());
        this.templateBuilders.put(PLUGIN_KEY, this.builder);
        this.setWebTemplatePath("war:/conf/wallet/templates/notification/web/RewardSuccessWebPlugin.gtmpl");
        this.setMailTemplatePath("war:/conf/wallet/templates/notification/mail/RewardSuccessMailPlugin.gtmpl");
        this.setPushTemplatePath("war:/conf/wallet/templates/notification/push/RewardSuccessPushPlugin.gtmpl");
    }

    public Map<PluginKey, String> getTemplateFilePathConfigs() {
        ChannelKey channelKey = this.getChannelKey();
        if (StringUtils.equals((CharSequence)channelKey.getId(), (CharSequence)"MAIL_CHANNEL")) {
            return Collections.singletonMap(PLUGIN_KEY, this.mailTemplatePath);
        }
        if (StringUtils.equals((CharSequence)channelKey.getId(), (CharSequence)"PUSH_CHANNEL")) {
            return Collections.singletonMap(PLUGIN_KEY, this.pushTemplatePath);
        }
        if (StringUtils.equals((CharSequence)channelKey.getId(), (CharSequence)"WEB_CHANNEL")) {
            return Collections.singletonMap(PLUGIN_KEY, this.webTemplatePath);
        }
        return Collections.emptyMap();
    }

    public String getWebTemplatePath() {
        return this.webTemplatePath;
    }

    public void setWebTemplatePath(String webTemplatePath) {
        this.webTemplatePath = webTemplatePath;
    }

    public String getPushTemplatePath() {
        return this.pushTemplatePath;
    }

    public void setPushTemplatePath(String pushTemplatePath) {
        this.pushTemplatePath = pushTemplatePath;
    }

    public String getMailTemplatePath() {
        return this.mailTemplatePath;
    }

    public void setMailTemplatePath(String mailTemplatePath) {
        this.mailTemplatePath = mailTemplatePath;
    }

    public RewardSuccessTemplateBuilder getBuilder() {
        return this.builder;
    }
}

