/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;

class ExoPortletInvocationContext
extends AbstractPortletInvocationContext {
    static final String INTERACTION_STATE_PARAM_NAME = "interactionstate";
    static final String NAVIGATIONAL_STATE_PARAM_NAME = "navigationalstate";
    static final String RESOURCE_STATE_PARAM_NAME = "resourcestate";
    private static final Log log = ExoLogger.getLogger(ExoPortletInvocationContext.class);
    private final HttpServletResponse response;
    private final HttpServletRequest request;
    private final PortalURL<UIComponent, ComponentURL> url;

    public ExoPortletInvocationContext(PortalRequestContext portalRequestContext, UIPortlet portlet) {
        super(MediaType.TEXT_HTML);
        ComponentURL url = (ComponentURL)portalRequestContext.createURL(ComponentURL.TYPE, (Object)portlet);
        String path = portalRequestContext.getNodePath();
        url.setPath(path);
        this.request = portalRequestContext.getRequest();
        this.response = portalRequestContext.getResponse();
        this.url = url;
    }

    public HttpServletRequest getClientRequest() throws IllegalStateException {
        return this.request;
    }

    public HttpServletResponse getClientResponse() throws IllegalStateException {
        return this.response;
    }

    public String encodeResourceURL(String url) throws IllegalArgumentException {
        return this.response.encodeURL(url);
    }

    public String renderURL(ContainerURL containerURL, URLFormat format) {
        String type;
        this.url.reset();
        if (containerURL instanceof RenderURL) {
            type = "render";
        } else if (containerURL instanceof ResourceURL) {
            type = "resource";
        } else if (containerURL instanceof ActionURL) {
            type = "action";
        } else {
            throw new Error("Unrecognized containerURL type");
        }
        if (!type.equals("render")) {
            this.url.setQueryParameterValue("portal:type", type);
        }
        if (format != null && format.getWantSecure() != null) {
            this.url.setQueryParameterValue("portal:isSecure", format.getWantSecure().toString());
        }
        if (containerURL instanceof ActionURL) {
            Mode mode;
            WindowState windowState;
            ActionURL actionURL = (ActionURL)containerURL;
            StateString state = actionURL.getInteractionState();
            if (state != null && !state.getStringValue().equals("JBPNS_")) {
                this.url.setQueryParameterValue(INTERACTION_STATE_PARAM_NAME, state.getStringValue());
            }
            if ((state = actionURL.getNavigationalState()) != null && !state.getStringValue().equals("JBPNS_")) {
                this.url.setQueryParameterValue(NAVIGATIONAL_STATE_PARAM_NAME, state.getStringValue());
            }
            if ((windowState = actionURL.getWindowState()) != null) {
                this.url.setQueryParameterValue("portal:windowState", windowState.toString());
            }
            if ((mode = actionURL.getMode()) != null) {
                this.url.setQueryParameterValue("portal:portletMode", mode.toString());
            }
        } else if (containerURL instanceof ResourceURL) {
            Mode mode;
            WindowState windowState;
            StateString resourceState;
            ResourceURL resourceURL = (ResourceURL)containerURL;
            this.url.setQueryParameterValue("portal:resourceID", resourceURL.getResourceId());
            CacheLevel cachability = resourceURL.getCacheability();
            if (cachability != null) {
                this.url.setQueryParameterValue("portal:cacheLevel", cachability.name());
            }
            if ((resourceState = resourceURL.getResourceState()) != null && !resourceState.getStringValue().equals("JBPNS_")) {
                this.url.setQueryParameterValue(RESOURCE_STATE_PARAM_NAME, resourceState.getStringValue());
            }
            if ((resourceState = resourceURL.getNavigationalState()) != null && !resourceState.getStringValue().equals("JBPNS_")) {
                this.url.setQueryParameterValue(NAVIGATIONAL_STATE_PARAM_NAME, resourceState.getStringValue());
            }
            if ((windowState = resourceURL.getWindowState()) != null) {
                this.url.setQueryParameterValue("portal:windowState", windowState.toString());
            }
            if ((mode = resourceURL.getMode()) != null) {
                this.url.setQueryParameterValue("portal:portletMode", mode.toString());
            }
        } else {
            StateString state;
            Map publicNSChanges;
            Mode mode;
            RenderURL renderURL = (RenderURL)containerURL;
            WindowState windowState = renderURL.getWindowState();
            if (windowState != null) {
                this.url.setQueryParameterValue("portal:windowState", windowState.toString());
            }
            if ((mode = renderURL.getMode()) != null) {
                this.url.setQueryParameterValue("portal:portletMode", mode.toString());
            }
            if (ParameterValidation.existsAndIsNotEmpty((Map)(publicNSChanges = renderURL.getPublicNavigationalStateChanges()))) {
                for (String key : publicNSChanges.keySet()) {
                    String[] values = (String[])publicNSChanges.get(key);
                    if (values != null && values.length > 0) {
                        for (String value : values) {
                            this.url.setQueryParameterValue(key, value);
                        }
                        continue;
                    }
                    this.url.setQueryParameterValue("removePP", key);
                }
            }
            if ((state = renderURL.getNavigationalState()) != null && !state.getStringValue().equals("JBPNS_")) {
                this.url.setQueryParameterValue(NAVIGATIONAL_STATE_PARAM_NAME, state.getStringValue());
            }
        }
        Map props = containerURL.getProperties();
        String lang = (String)props.get("gtn:lang");
        if (lang != null) {
            if (lang.length() == 0) {
                this.url.setLocale(null);
            } else {
                try {
                    Locale locale = I18N.parseJavaIdentifier((String)lang);
                    this.url.setLocale(locale);
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)("Unparsable locale string: " + lang), (Throwable)e);
                }
            }
        }
        this.url.setAjax(Boolean.valueOf("true".equals(props.get("gtn:ajax"))));
        this.url.setConfirm((String)props.get("gtn:confirm"));
        String csrfCheck = (String)props.get("gtn:csrfCheck");
        this.url.setCSRFCheck(Boolean.parseBoolean(csrfCheck));
        MimeType mimeType = Boolean.TRUE.equals(format.getWantEscapeXML()) ? MimeType.XHTML : MimeType.PLAIN;
        this.url.setMimeType(mimeType);
        return this.url.toString();
    }
}

