/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.web.ConversationStateListener;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class JAASConversationStateListener
extends ConversationStateListener {
    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
        try {
            ConversationRegistry conversationRegistry;
            ConversationState conversationState;
            ExoContainer container = this.getContainerIfPresent(httpSession.getServletContext());
            if (container != null && (conversationState = (conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class)).unregister(stateKey)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Remove conversation state " + httpSession.getId()));
                }
                if (conversationState.getAttribute("subject") != null) {
                    Subject subject = (Subject)conversationState.getAttribute("subject");
                    String realmName = container instanceof PortalContainer ? ((PortalContainer)container).getRealmName() : PortalContainer.DEFAULT_REALM_NAME;
                    LoginContext ctx = new LoginContext(realmName, subject);
                    ctx.logout();
                } else if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Subject was not found in ConversationState attributes.");
                }
            }
        }
        catch (LoginException e) {
            LOG.error((Object)("Can't remove conversation state " + httpSession.getId()));
        }
        catch (SecurityException e) {
            LOG.error((Object)("Can't remove conversation state " + httpSession.getId()));
        }
    }
}

