/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialMembershipListenerImpl
extends MembershipEventListener {
    private static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";

    public void postDelete(Membership m) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            UserACL acl = (UserACL)CommonsUtils.getService(UserACL.class);
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                boolean hasPublisherMembership;
                boolean hasMemberMembership;
                boolean hasManagerMembership;
                ConversationState state = ConversationState.getCurrent();
                if (state != null && state.getIdentity() != null && space.getEditor() == null) {
                    space.setEditor(state.getIdentity().getUserId());
                }
                IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
                Identity deletedMembershipIdentity = identityRegistry.getIdentity(m.getUserName());
                OrganizationService orgService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
                boolean bl = deletedMembershipIdentity != null ? deletedMembershipIdentity.isMemberOf(m.getGroupId(), acl.getAdminMSType()) : (hasManagerMembership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), acl.getAdminMSType()) != null);
                boolean bl2 = deletedMembershipIdentity != null ? deletedMembershipIdentity.isMemberOf(m.getGroupId(), "member") : (hasMemberMembership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), "member") != null);
                boolean bl3 = deletedMembershipIdentity != null ? deletedMembershipIdentity.isMemberOf(m.getGroupId(), "publisher") : (hasPublisherMembership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(m.getUserName(), m.getGroupId(), "publisher") != null);
                if (!hasManagerMembership) {
                    spaceService.setManager(space, m.getUserName(), false);
                }
                if (!hasMemberMembership) {
                    spaceService.removeMember(space, m.getUserName());
                }
                if (!hasPublisherMembership) {
                    spaceService.removePublisher(space, m.getUserName());
                }
                SpaceUtils.refreshNavigation();
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
            SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                ConversationState state = ConversationState.getCurrent();
                if (state != null && state.getIdentity() != null && space.getEditor() == null) {
                    space.setEditor(state.getIdentity().getUserId());
                }
                String userName = m.getUserName();
                if (acl.getAdminMSType().equalsIgnoreCase(m.getMembershipType()) || "*".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isManager(space, userName)) {
                        return;
                    }
                    if (spaceService.isMember(space, userName)) {
                        spaceService.setManager(space, userName, true);
                    } else {
                        spaceService.addMember(space, userName);
                        spaceService.setManager(space, userName, true);
                    }
                } else if ("member".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isMember(space, userName)) {
                        return;
                    }
                    spaceService.addMember(space, userName);
                } else if ("redactor".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isRedactor(space, userName)) {
                        return;
                    }
                    spaceService.addRedactor(space, userName);
                } else if ("publisher".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isPublisher(space, userName)) {
                        return;
                    }
                    spaceService.addPublisher(space, userName);
                }
                SpaceUtils.refreshNavigation();
            }
        } else if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP)) {
            OrganizationService orgService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            User user = orgService.getUserHandler().findUserByName(m.getUserName());
            List spacesToJoin = spaceService.findExternalInvitationsSpacesByEmail(user.getEmail());
            for (String spaceId : spacesToJoin) {
                Space space = spaceService.getSpaceById(spaceId);
                spaceService.addMember(space, user.getUserName());
            }
            spaceService.deleteExternalUserInvitations(user.getEmail());
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    private void clearIdentityCaching() {
        IdentityStorage storage = (IdentityStorage)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityStorage.class);
        storage.updateIdentityMembership(null);
    }
}

