/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationImage;
import org.exoplatform.appcenter.dto.ApplicationList;
import org.exoplatform.appcenter.dto.ApplicationOrder;
import org.exoplatform.appcenter.dto.GeneralSettings;
import org.exoplatform.appcenter.service.ApplicationAlreadyExistsException;
import org.exoplatform.appcenter.service.ApplicationCenterService;
import org.exoplatform.appcenter.service.ApplicationNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;

@Path(value="app-center")
@RolesAllowed(value={"users"})
@Tag(name="/app-center", description="Manage and access application center applications")
public class ApplicationCenterREST
implements ResourceContainer {
    private static final String APPLICATIONS_ENDPOINT = "applications";
    private static final String SETTINGS_ENDPOINT = "settings";
    private static final String FAVORITES_APPLICATIONS_ENDPOINT = "applications/favorites";
    private static final String AUTHORIZED_APPLICATIONS_ENDPOINT = "applications/authorized";
    private static final String LOG_OPEN_DRAWER_ENDPOINT = "applications/logOpenDrawer";
    private static final String LOG_CLICK_ALL_APPLICATIONS_ENDPOINT = "applications/logClickAllApplications";
    private static final String LOG_CLICK_ONE_APPLICATION_ENDPOINT = "applications/logClickApplication";
    private static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    private static final int CACHE_DURATION_SECONDS = 31536000;
    private static final long CACHE_DURATION_MILLISECONDS = 31536000000L;
    private static final CacheControl ILLUSTRATION_CACHE_CONTROL = new CacheControl();
    private static final Log LOG;
    private ApplicationCenterService appCenterService;
    private final String baseURI;

    public ApplicationCenterREST(ApplicationCenterService appCenterService, PortalContainer container) {
        this.appCenterService = appCenterService;
        this.baseURI = "/" + container.getName() + "/" + container.getRestContextName() + "/";
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves all available sub resources of current endpoint", method="GET", description="Retrieves all available sub resources of current endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAvailableSubResources() {
        try {
            HashMap<String, List<String>> availableEnpoints = new HashMap<String, List<String>>();
            ConversationState current = ConversationState.getCurrent();
            if (current.getIdentity().isMemberOf(new MembershipEntry(ADMINISTRATORS_GROUP, "*"))) {
                availableEnpoints.put("subResourcesHref", Arrays.asList(this.baseURI + FAVORITES_APPLICATIONS_ENDPOINT, this.baseURI + AUTHORIZED_APPLICATIONS_ENDPOINT, this.baseURI + SETTINGS_ENDPOINT, this.baseURI + APPLICATIONS_ENDPOINT));
            } else {
                availableEnpoints.put("subResourcesHref", Arrays.asList(this.baseURI + FAVORITES_APPLICATIONS_ENDPOINT, this.baseURI + AUTHORIZED_APPLICATIONS_ENDPOINT, this.baseURI + SETTINGS_ENDPOINT));
            }
            return Response.ok(availableEnpoints).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Retrieves all available applications", method="GET", description="Return list of applications in json format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApplicationsList(@Parameter(description="Query Offset", required=true) @QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit, @Parameter(description="Keyword to search in applications title and url", required=true) @QueryParam(value="keyword") String keyword) {
        try {
            ApplicationList applicationList = this.appCenterService.getApplicationsList(offset, limit, keyword);
            return Response.ok((Object)applicationList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/authorized")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves all authorized applications for currently authenticated user", method="GET", description="Return list of applications in json format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAuthorizedApplicationsList(@Parameter(description="Query Offset", required=true) @QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit, @Parameter(description="Keyword to search in applications title and url", required=true) @QueryParam(value="keyword") String keyword) {
        try {
            ApplicationList applicationList = this.appCenterService.getAuthorizedApplicationsList(offset, limit, keyword, this.getCurrentUserName());
            return Response.ok((Object)applicationList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/favorites")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves favorite applications for currently authenticated user", method="GET", description="Return list of applications in json format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getFavoriteApplicationsList() {
        try {
            ApplicationList applicationList = this.appCenterService.getMandatoryAndFavoriteApplicationsList(this.getCurrentUserName());
            return Response.ok((Object)applicationList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/logClickAllApplications")
    @RolesAllowed(value={"users"})
    @Operation(summary="Log that the currently authenticated user clicked on View All Applications button", method="GET", description="Log that the currently authenticated user clicked on View All Applications button and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response logClickAllApplications() {
        try {
            LOG.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, ApplicationCenterService.LOG_CLICK_ALL_APPLICATIONS, this.getCurrentUserName(), "0"});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/logClickApplication/{applicationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Log that the currently authenticated user clicked on one Application", method="GET", description="Log that the currently authenticated user clicked on one Application and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response logClickOneApplications(@Parameter(description="Application technical id to log", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            Application application = this.appCenterService.findApplication(applicationId);
            LOG.info("service={} operation={} parameters=\"user:{},applicationId={},applicationName={}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "open-application", this.getCurrentUserName(), applicationId, application.getTitle(), "0"});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/logOpenDrawer")
    @RolesAllowed(value={"users"})
    @Operation(summary="Log that the currently authenticated user has opened the favorites drawer", method="GET", description="Log that the currently authenticated user has opened the favorites drawer and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response logOpenDrawer() {
        try {
            LOG.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, ApplicationCenterService.LOG_OPEN_FAVORITE_DRAWER, this.getCurrentUserName(), "0"});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="settings")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Modifies default application image setting", method="GET", description="Modifies default application image setting and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAppGeneralSettings() {
        try {
            GeneralSettings generalSettings = this.appCenterService.getAppGeneralSettings();
            return Response.ok((Object)generalSettings).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="applications")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Creates a new application in application center", method="GET", description="Creates a new application in application center and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createApplication(@RequestBody(description="Application to save", required=true) Application application) {
        try {
            this.appCenterService.createApplication(application);
        }
        catch (ApplicationAlreadyExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="applications")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Updates an existing application identified by its id or title or url", method="GET", description="Updates an existing application identified by its id or title or url")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateApplication(@RequestBody(description="Application to update", required=true) Application application) {
        try {
            application.setChangedManually(true);
            this.appCenterService.updateApplication(application, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationAlreadyExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="applications/{applicationId}")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Deletes an existing application identified by its id", method="GET", description="Deletes an existing application identified by its id")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteApplication(@Parameter(description="Application technical id to delete", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            this.appCenterService.deleteApplication(applicationId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="applications/favorites/{applicationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Adds an existing application identified by its id as favorite for current authenticated user", method="GET", description="Adds an existing application identified by its id as favorite for current authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response addFavoriteApplication(@Parameter(description="Application technical id to add as favorite", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            long startTime = System.currentTimeMillis();
            Application application = this.appCenterService.findApplication(applicationId);
            this.appCenterService.addFavoriteApplication(applicationId, this.getCurrentUserName());
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"user:{},applicationId={},applicationName={}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "add-favorite", this.getCurrentUserName(), applicationId, application.getTitle(), totalTime});
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while adding application as favorite", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="applications/favorites")
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing application's order identified by its id", method="GET", description="Updates an existing application's order identified by its id and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateApplicationsOrder(@RequestBody(description="Application to update", required=true) List<ApplicationOrder> applicationOrders) {
        try {
            long startTime = System.currentTimeMillis();
            for (ApplicationOrder applicationOrder : applicationOrders) {
                this.appCenterService.updateFavoriteApplicationOrder(applicationOrder, this.getCurrentUserName());
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "reorganize-favorites", this.getCurrentUserName(), totalTime});
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while adding application as favorite", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="applications/favorites/{applicationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes an existing application identified by its id from current authenticated user favorites", method="GET", description="Deletes an existing application identified by its id from current authenticated user favorites and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteFavoriteApplication(@Parameter(description="Application technical id to delete from favorite", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            long startTime = System.currentTimeMillis();
            Application application = this.appCenterService.findApplication(applicationId);
            this.appCenterService.deleteFavoriteApplication(applicationId, this.getCurrentUserName());
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"user:{},applicationId={},applicationName={}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "remove-favorite", this.getCurrentUserName(), applicationId, application.getTitle(), totalTime});
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting application from favorites", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PATCH
    @Path(value="settings/maxFavorites")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Modifies maximum application count to add as favorites for all users", method="GET", description="Modifies maximum application count to add as favorites for all users")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response setMaxFavoriteApps(@Parameter(description="Max favorites number", required=true) @QueryParam(value="number") long number) {
        try {
            this.appCenterService.setMaxFavoriteApps(number);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="settings/image")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Modifies default application image setting", method="GET", description="Modifies default application image setting")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response setDefaultAppImage(@Parameter(description="Application image id, body and name", required=true) ApplicationImage defaultAppImage) {
        try {
            this.appCenterService.setDefaultAppImage(defaultAppImage);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/illustration/{applicationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets an application illustration by application id", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getApplicationIllustration(@Context Request request, @Parameter(description="Application id", required=true) @PathParam(value="applicationId") long applicationId, @Parameter(description="Optional last modified parameter") @QueryParam(value="v") long lastModified) {
        try {
            Long lastUpdated = this.appCenterService.getApplicationImageLastUpdated(applicationId, this.getCurrentUserName());
            if (lastUpdated == null) {
                return Response.status((int)404).build();
            }
            EntityTag eTag = new EntityTag(String.valueOf(lastUpdated), true);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = this.appCenterService.getApplicationImageInputStream(applicationId, this.getCurrentUserName());
                if (stream == null) {
                    return Response.status((int)404).build();
                }
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
                if (lastModified > 0L) {
                    builder.lastModified(new Date(lastUpdated));
                    builder.expires(new Date(System.currentTimeMillis() + 31536000000L));
                    builder.cacheControl(ILLUSTRATION_CACHE_CONTROL);
                }
            }
            return builder.build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unauthorised access to application {} illustration", new Object[]{applicationId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ApplicationNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting application illustration", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }

    static {
        ILLUSTRATION_CACHE_CONTROL.setMaxAge(31536000);
        LOG = ExoLogger.getLogger(ApplicationCenterREST.class);
    }
}

