/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxNavigatorFactory {
    public static <N> StaxNavigator<N> create(Naming<N> naming, XMLStreamReader stream) throws NullPointerException, StaxNavException {
        if (naming == null) {
            throw new NullPointerException("No null naming accepted");
        }
        if (stream == null) {
            throw new NullPointerException("No null stream accepted");
        }
        try {
            return new StaxNavigatorImpl<N>(naming, stream);
        }
        catch (XMLStreamException e) {
            throw new StaxNavException(e);
        }
    }

    public static <N> StaxNavigator<N> create(Naming<N> naming, InputStream is) throws NullPointerException, StaxNavException {
        if (naming == null) {
            throw new NullPointerException("No null naming accepted");
        }
        if (is == null) {
            throw new NullPointerException("No null input stream accepted");
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader stream = factory.createXMLStreamReader(is);
            return new StaxNavigatorImpl<N>(naming, stream);
        }
        catch (XMLStreamException e) {
            throw new StaxNavException(e);
        }
    }

    public static <N> StaxNavigator<N> create(Naming<N> naming, Reader reader) throws NullPointerException, StaxNavException {
        if (naming == null) {
            throw new NullPointerException("No null naming accepted");
        }
        if (reader == null) {
            throw new NullPointerException("No null reader accepted");
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader stream = factory.createXMLStreamReader(reader);
            return new StaxNavigatorImpl<N>(naming, stream);
        }
        catch (XMLStreamException e) {
            throw new StaxNavException(e);
        }
    }
}

