/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import opennlp.tools.util.wordvector.WordVector;
import opennlp.tools.util.wordvector.WordVectorType;

class FloatArrayVector
implements WordVector {
    private final float[] vector;

    FloatArrayVector(float[] vector) {
        this.vector = vector;
    }

    @Override
    public WordVectorType getDataType() {
        return WordVectorType.FLOAT;
    }

    @Override
    public float getAsFloat(int index) {
        return this.vector[index];
    }

    @Override
    public double getAsDouble(int index) {
        return this.getAsFloat(index);
    }

    @Override
    public FloatBuffer toFloatBuffer() {
        return FloatBuffer.wrap(this.vector).asReadOnlyBuffer();
    }

    @Override
    public DoubleBuffer toDoubleBuffer() {
        double[] doubleVector = new double[this.vector.length];
        for (int i = 0; i < doubleVector.length; ++i) {
            doubleVector[i] = this.vector[i];
        }
        return DoubleBuffer.wrap(doubleVector).asReadOnlyBuffer();
    }

    @Override
    public int dimension() {
        return this.vector.length;
    }
}

