/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.WritablePixelIterator;

final class BandedIterator
extends WritablePixelIterator {
    private DataBuffer buffer;
    private DataBuffer destBuffer;
    private int sampleModelTranslateX;
    private int sampleModelTranslateY;
    private int xToBuffer;
    private final int scanlineStride;

    BandedIterator(Raster raster, WritableRaster writableRaster, Rectangle rectangle, Dimension dimension, SequenceType sequenceType, int n) {
        super(raster, writableRaster, rectangle, dimension, sequenceType);
        this.scanlineStride = n;
        this.acquiredTile(raster);
        this.changedRowOrTile();
    }

    BandedIterator(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage, Rectangle rectangle, Dimension dimension, SequenceType sequenceType, int n) {
        super(renderedImage, writableRenderedImage, rectangle, dimension, sequenceType);
        this.scanlineStride = n;
    }

    @Override
    final void changedRowOrTile() {
        this.xToBuffer = (this.y - this.sampleModelTranslateY) * this.scanlineStride - this.sampleModelTranslateX;
    }

    @Override
    public void moveTo(int n, int n2) {
        if (this.isSameRowAndTile(n, n2)) {
            this.x = n;
        } else {
            super.moveTo(n, n2);
            this.changedRowOrTile();
        }
    }

    @Override
    final void acquiredTile(Raster raster) {
        assert (PixelIterator.Builder.getScanlineStride(raster.getSampleModel()) == this.scanlineStride);
        this.sampleModelTranslateY = raster.getSampleModelTranslateY();
        this.sampleModelTranslateX = raster.getSampleModelTranslateX();
        this.buffer = raster.getDataBuffer();
        raster = this.destination();
        if (raster != null) {
            this.destBuffer = raster.getDataBuffer();
            assert (PixelIterator.Builder.getScanlineStride(raster.getSampleModel()) == this.scanlineStride && raster.getSampleModelTranslateX() == this.sampleModelTranslateX && raster.getSampleModelTranslateY() == this.sampleModelTranslateY);
        }
    }

    @Override
    final void releaseTile() {
        if (this.image != null) {
            this.buffer = null;
            this.destBuffer = null;
        }
        super.releaseTile();
    }

    @Override
    public int getSample(int n) {
        return this.buffer.getElem(n, this.x + this.xToBuffer);
    }

    @Override
    public float getSampleFloat(int n) {
        return this.buffer.getElemFloat(n, this.x + this.xToBuffer);
    }

    @Override
    public double getSampleDouble(int n) {
        return this.buffer.getElemDouble(n, this.x + this.xToBuffer);
    }

    @Override
    public void setSample(int n, int n2) {
        this.destBuffer.setElem(n, this.x + this.xToBuffer, n2);
    }

    @Override
    public void setSample(int n, float f) {
        this.destBuffer.setElemFloat(n, this.x + this.xToBuffer, f);
    }

    @Override
    public void setSample(int n, double d) {
        this.destBuffer.setElemDouble(n, this.x + this.xToBuffer, d);
    }

    @Override
    public int[] getPixel(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n = this.x + this.xToBuffer;
        nArray[0] = this.buffer.getElem(n);
        for (int i = 1; i < this.numBands; ++i) {
            nArray[i] = this.buffer.getElem(i, n);
        }
        return nArray;
    }

    @Override
    public float[] getPixel(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n = this.x + this.xToBuffer;
        fArray[0] = this.buffer.getElemFloat(n);
        for (int i = 1; i < this.numBands; ++i) {
            fArray[i] = this.buffer.getElemFloat(i, n);
        }
        return fArray;
    }

    @Override
    public double[] getPixel(double[] dArray) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        int n = this.x + this.xToBuffer;
        dArray[0] = this.buffer.getElemDouble(n);
        for (int i = 1; i < this.numBands; ++i) {
            dArray[i] = this.buffer.getElemDouble(i, n);
        }
        return dArray;
    }

    @Override
    public void setPixel(int[] nArray) {
        int n = this.x + this.xToBuffer;
        this.destBuffer.setElem(n, nArray[0]);
        for (int i = 1; i < this.numBands; ++i) {
            this.destBuffer.setElem(i, n, nArray[i]);
        }
    }

    @Override
    public void setPixel(float[] fArray) {
        int n = this.x + this.xToBuffer;
        this.destBuffer.setElemFloat(n, fArray[0]);
        for (int i = 1; i < this.numBands; ++i) {
            this.destBuffer.setElemFloat(i, n, fArray[i]);
        }
    }

    @Override
    public void setPixel(double[] dArray) {
        int n = this.x + this.xToBuffer;
        this.destBuffer.setElemDouble(n, dArray[0]);
        for (int i = 1; i < this.numBands; ++i) {
            this.destBuffer.setElemDouble(i, n, dArray[i]);
        }
    }

    @Override
    PixelIterator.Window<FloatBuffer> createWindow(float[] fArray, float[] fArray2) {
        return new FloatWindow(fArray, fArray2);
    }

    @Override
    PixelIterator.Window<DoubleBuffer> createWindow(double[] dArray, double[] dArray2) {
        return new DoubleWindow(dArray, dArray2);
    }

    private final class FloatWindow
    extends PixelIterator.Window<FloatBuffer> {
        private final float[] data;
        private final float[] transfer;

        FloatWindow(float[] fArray, float[] fArray2) {
            super(FloatBuffer.wrap(fArray).asReadOnlyBuffer());
            this.data = fArray;
            this.transfer = fArray2;
        }

        @Override
        final PixelIterator owner() {
            return BandedIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, int n5) {
            float[] fArray;
            float[] fArray2 = fArray = n5 == 0 ? this.data : this.transfer;
            if (n5 != 2 && n2 == BandedIterator.this.y) {
                DataBuffer dataBuffer = BandedIterator.this.buffer;
                int n6 = BandedIterator.this.scanlineStride - n3;
                int n7 = BandedIterator.this.numBands;
                int n8 = n + BandedIterator.this.xToBuffer;
                int n9 = 0;
                do {
                    int n10 = n3;
                    do {
                        fArray[n9++] = dataBuffer.getElemFloat(n8);
                        for (int i = 1; i < n7; ++i) {
                            fArray[n9++] = dataBuffer.getElemFloat(i, n8);
                        }
                        ++n8;
                    } while (--n10 != 0);
                    n8 += n6;
                } while (--n4 != 0);
                return fArray;
            }
            return raster.getPixels(n, n2, n3, n4, fArray);
        }

        @Override
        public void update() {
            ((FloatBuffer)this.values).clear();
            BandedIterator.this.fetchValues(this, this.data);
        }
    }

    private final class DoubleWindow
    extends PixelIterator.Window<DoubleBuffer> {
        private final double[] data;
        private final double[] transfer;

        DoubleWindow(double[] dArray, double[] dArray2) {
            super(DoubleBuffer.wrap(dArray).asReadOnlyBuffer());
            this.data = dArray;
            this.transfer = dArray2;
        }

        @Override
        final PixelIterator owner() {
            return BandedIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int n, int n2, int n3, int n4, int n5) {
            double[] dArray;
            double[] dArray2 = dArray = n5 == 0 ? this.data : this.transfer;
            if (n5 != 2 && n2 == BandedIterator.this.y) {
                DataBuffer dataBuffer = BandedIterator.this.buffer;
                int n6 = BandedIterator.this.scanlineStride - n3;
                int n7 = BandedIterator.this.numBands;
                int n8 = n + BandedIterator.this.xToBuffer;
                int n9 = 0;
                do {
                    int n10 = n3;
                    do {
                        dArray[n9++] = dataBuffer.getElemDouble(n8);
                        for (int i = 1; i < n7; ++i) {
                            dArray[n9++] = dataBuffer.getElemDouble(i, n8);
                        }
                        ++n8;
                    } while (--n10 != 0);
                    n8 += n6;
                } while (--n4 != 0);
                return dArray;
            }
            return raster.getPixels(n, n2, n3, n4, dArray);
        }

        @Override
        public void update() {
            ((DoubleBuffer)this.values).clear();
            BandedIterator.this.fetchValues(this, this.data);
        }
    }
}

