/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.internal;

import java.util.ArrayList;

public class StringSplitter {
    private final String regex;
    private final boolean trim;
    private final boolean ignoreEmptyStrings;
    private final int limit;

    private StringSplitter(String regex) {
        this(regex, false, false, 0);
    }

    private StringSplitter(String regex, boolean trim, boolean ignoreEmptyStrings, int limit) {
        this.regex = regex;
        this.trim = trim;
        this.ignoreEmptyStrings = ignoreEmptyStrings;
        this.limit = limit;
    }

    public StringSplitter trim() {
        return new StringSplitter(this.regex, true, this.ignoreEmptyStrings, this.limit);
    }

    public StringSplitter ignoreEmptyStrings() {
        return new StringSplitter(this.regex, this.trim, true, this.limit);
    }

    public StringSplitter limit(int limit) {
        return new StringSplitter(this.regex, this.trim, this.ignoreEmptyStrings, limit);
    }

    public String[] split(String string) {
        if (string == null) {
            return null;
        }
        String[] split = string.split(this.regex, this.limit);
        ArrayList<String> list = new ArrayList<String>(split.length);
        for (String s : split) {
            boolean add;
            if (this.trim) {
                s = this.trim(s);
            }
            boolean bl = add = !this.ignoreEmptyStrings || s != null && s.length() != 0;
            if (!add) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    private String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static StringSplitter splitter(String regex) {
        return new StringSplitter(regex);
    }
}

