/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.wkt.FirstKeywordPeek;
import org.apache.sis.internal.storage.wkt.Store;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Version;

@StoreMetadata(formatName="WKT", fileSuffixes={"prj"}, capabilities={Capability.READ})
public final class StoreProvider
extends URIDataStore.Provider {
    public static final String NAME = "WKT";

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        return Peek.INSTANCE.probeContent(this, storageConnector);
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new Store(this, storageConnector);
    }

    static final class Peek
    extends FirstKeywordPeek {
        static final Peek INSTANCE = new Peek();
        static final int MIN_LENGTH = 6;
        private final Set<String> keywords;

        private Peek() {
            super(14);
            HashSet<String> hashSet = new HashSet<String>(22);
            hashSet.add("GeodeticCRS");
            hashSet.add("GeodCRS");
            hashSet.add("GeogCS");
            hashSet.add("GeocCS");
            hashSet.add("VerticalCRS");
            hashSet.add("VertCRS");
            hashSet.add("Vert_CS");
            hashSet.add("TimeCRS");
            hashSet.add("ImageCRS");
            hashSet.add("EngineeringCRS");
            hashSet.add("EngCRS");
            hashSet.add("Local_CS");
            hashSet.add("CompoundCRS");
            hashSet.add("Compd_CS");
            hashSet.add("ProjectedCRS");
            hashSet.add("ProjCRS");
            hashSet.add("ProjCS");
            hashSet.add("Fitted_CS");
            hashSet.add("BoundCRS");
            this.keywords = hashSet;
        }

        final Set<String> keywords() {
            return Collections.unmodifiableSet(this.keywords);
        }

        @Override
        protected boolean isPostKeyword(int n) {
            return n == 91 || n == 40;
        }

        @Override
        protected ProbeResult forKeyword(char[] cArray, int n) {
            if (n >= 6) {
                int n2 = n;
                int n3 = 1;
                cArray[0] = (char)(cArray[0] & 0xFFFFFFDF);
                int n4 = --n2;
                cArray[n4] = (char)(cArray[n4] & 0xFFFFFFDF);
                int n5 = --n2;
                cArray[n5] = (char)(cArray[n5] & 0xFFFFFFDF);
                if (cArray[n5] == 'R') {
                    int n6 = --n2;
                    cArray[n6] = (char)(cArray[n6] & 0xFFFFFFDF);
                    n3 = 2;
                }
                while (--n2 != 0) {
                    if (cArray[n2] == '_') continue;
                    int n7 = n2;
                    cArray[n7] = (char)(cArray[n7] | 0x20);
                }
                if (this.keywords.contains(String.valueOf(cArray, 0, n))) {
                    return new ProbeResult(true, null, Version.valueOf((int[])new int[]{n3}));
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

