/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.wallet.model.reward.RewardBudgetType;
import org.exoplatform.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.reward.api.RewardPlugin;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.exoplatform.wallet.utils.RewardUtils;
import org.exoplatform.wallet.utils.WalletUtils;

public class WalletRewardSettingsService
implements RewardSettingsService {
    private SettingService settingService;
    private RewardSettings configuredRewardSettings;
    private Map<String, RewardPlugin> rewardPlugins = new HashMap<String, RewardPlugin>();

    public WalletRewardSettingsService(SettingService settingService) {
        this.settingService = settingService;
    }

    public RewardSettings getSettings() {
        Set<String> configuredPluginIds;
        if (this.configuredRewardSettings != null) {
            return this.configuredRewardSettings.clone();
        }
        SettingValue settingsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS");
        String settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        RewardSettings rewardSettings = null;
        rewardSettings = settingsValueString == null ? new RewardSettings() : (RewardSettings)WalletUtils.fromJsonString((String)settingsValueString, RewardSettings.class);
        HashSet<RewardPluginSettings> pluginSettings = rewardSettings.getPluginSettings();
        if (pluginSettings == null) {
            pluginSettings = new HashSet<RewardPluginSettings>();
            rewardSettings.setPluginSettings(pluginSettings);
        }
        if (!(configuredPluginIds = this.rewardPlugins.keySet()).isEmpty()) {
            for (String configuredPluginId : configuredPluginIds) {
                if (!pluginSettings.stream().noneMatch(plugin -> StringUtils.equals((CharSequence)plugin.getPluginId(), (CharSequence)configuredPluginId))) continue;
                RewardPluginSettings emptyRewardSettings = new RewardPluginSettings();
                emptyRewardSettings.setPluginId(configuredPluginId);
                pluginSettings.add(emptyRewardSettings);
            }
        }
        for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
            if (rewardPluginSettings == null) continue;
            String pluginId = rewardPluginSettings.getPluginId();
            RewardPlugin rewardPlugin = this.getRewardPlugin(pluginId);
            boolean enabled = false;
            if (rewardPlugin != null) {
                enabled = rewardPlugin.isEnabled();
            }
            rewardPluginSettings.setEnabled(enabled);
        }
        this.configuredRewardSettings = rewardSettings;
        return this.configuredRewardSettings;
    }

    public void saveSettings(RewardSettings rewardSettingsToStore) {
        if (rewardSettingsToStore == null) {
            throw new IllegalArgumentException("Empty settings to save");
        }
        Set pluginSettings = rewardSettingsToStore.getPluginSettings();
        if (pluginSettings != null && !pluginSettings.isEmpty()) {
            for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
                if (rewardPluginSettings.getBudgetType() != RewardBudgetType.FIXED_PER_POINT) continue;
                rewardPluginSettings.setUsePools(false);
            }
        }
        String settingsString = WalletUtils.toJsonString((Object)rewardSettingsToStore);
        this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS", SettingValue.create((String)settingsString));
        this.configuredRewardSettings = null;
    }

    public void registerPlugin(RewardPlugin rewardPlugin) {
        this.rewardPlugins.put(rewardPlugin.getPluginId(), rewardPlugin);
        this.configuredRewardSettings = null;
    }

    public void unregisterPlugin(String pluginId) {
        this.rewardPlugins.remove(pluginId);
        this.configuredRewardSettings = null;
    }

    public Collection<RewardPlugin> getRewardPlugins() {
        return this.rewardPlugins.values();
    }

    public RewardPlugin getRewardPlugin(String pluginId) {
        return this.rewardPlugins.get(pluginId);
    }
}

