/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.viewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.connector.clouddrives.ContentService;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.viewer.DocumentNotFoundException;
import org.exoplatform.services.cms.clouddrives.viewer.ViewerStorage;
import org.exoplatform.services.cms.clouddrives.webui.viewer.AbstractFileForm;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/templates/PDFViewer.gtmpl", events={@EventConfig(listeners={NextPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={PreviousPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={GotoPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RotateRightPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RotateLeftPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ScalePageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ZoomInPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ZoomOutPageActionListener.class}, phase=Event.Phase.DECODE)})
public class PDFViewer
extends AbstractFileForm {
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String SCALE_PAGE = "scalePage";
    private static final String localeFile = "locale.portlet.viewer.PDFViewer";
    private final ViewerStorage storage = (ViewerStorage)this.getApplicationComponent(ViewerStorage.class);
    private final RepositoryService jcrService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
    private ViewerStorage.PDFFile pdfFile;
    private String pdfLink;
    private String pdfPageLink;
    private int currentPageNumber = 1;
    private float currentRotation = 0.0f;
    private float currentScale = 1.0f;

    public PDFViewer() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_NUMBER, PAGE_NUMBER, "1"));
        UIFormSelectBox uiScaleBox = new UIFormSelectBox(SCALE_PAGE, SCALE_PAGE, this.initScaleOptions());
        uiScaleBox.setOnChange("ScalePage");
        this.addUIFormInput((UIFormInput)uiScaleBox);
        uiScaleBox.setValue("1.0f");
    }

    @Override
    public boolean isViewable() {
        return this.pdfFile != null && super.isViewable();
    }

    @Override
    protected String localeFile() {
        return localeFile;
    }

    @Override
    public void initFile(CloudDrive drive, CloudFile file) {
        this.pdfFile = null;
        this.pdfPageLink = null;
        this.pdfLink = null;
        super.initFile(drive, file);
        try {
            String repository = this.jcrService.getCurrentRepository().getConfiguration().getName();
            String workspace = drive.getWorkspace();
            ViewerStorage.ContentFile contentFile = this.storage.createFile(repository, workspace, drive, file);
            if (contentFile.isPDF()) {
                this.pdfFile = contentFile.asPDF();
                String contentLink = ContentService.contentLink((String)workspace, (String)file.getPath(), (String)file.getId());
                this.pdfLink = ContentService.pdfLink((String)contentLink);
                this.pdfPageLink = ContentService.pdfPageLink((String)contentLink);
            } else {
                LOG.warn((Object)("Current file view is not of PDF format " + file.getPath()));
            }
        }
        catch (DocumentNotFoundException e) {
            LOG.error((Object)"Error preparing PDF viewer", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error initializing PDF viewer", (Throwable)e);
        }
        catch (DriveRemovedException e) {
            LOG.warn((Object)("Error initializing PDF viewer: " + e.getMessage()));
        }
        catch (CloudDriveException e) {
            LOG.warn((Object)("Error initializing PDF viewer: " + e.getMessage()));
        }
        catch (IOException e) {
            LOG.warn((Object)("Error initializing PDF viewer: " + e.getMessage()));
        }
    }

    public Map<String, String> getFileMetadata() {
        if (this.pdfFile != null) {
            return this.pdfFile.getMetadata();
        }
        return Collections.emptyMap();
    }

    public int getNumberOfPages() {
        if (this.pdfFile != null) {
            return this.pdfFile.getNumberOfPages();
        }
        return 0;
    }

    public String getPageImageLink() {
        if (this.pdfPageLink != null) {
            StringBuilder link = new StringBuilder();
            link.append(this.pdfPageLink);
            link.append(this.pdfPageLink.indexOf(63) > 0 ? (char)'&' : '?');
            link.append("page=");
            link.append(this.getPageNumber());
            link.append("&rotation=");
            link.append(this.getCurrentRotation());
            link.append("&scale=");
            link.append(this.getCurrentScale());
            return link.toString();
        }
        return null;
    }

    public String getPdfLink() {
        return this.pdfLink;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public void setRotation(float rotation) {
        this.currentRotation = rotation;
    }

    public float getCurrentScale() {
        return this.currentScale;
    }

    public void setScale(float scale) {
        this.currentScale = scale;
    }

    public int getPageNumber() {
        return this.currentPageNumber;
    }

    public void setPageNumber(int pageNum) {
        this.currentPageNumber = pageNum;
    }

    private List<SelectItemOption<String>> initScaleOptions() {
        ArrayList<SelectItemOption<String>> scaleOptions = new ArrayList<SelectItemOption<String>>();
        scaleOptions.add(new SelectItemOption("5%", (Object)"0.05f"));
        scaleOptions.add(new SelectItemOption("10%", (Object)"0.1f"));
        scaleOptions.add(new SelectItemOption("25%", (Object)"0.25f"));
        scaleOptions.add(new SelectItemOption("50%", (Object)"0.5f"));
        scaleOptions.add(new SelectItemOption("75%", (Object)"0.75f"));
        scaleOptions.add(new SelectItemOption("100%", (Object)"1.0f"));
        scaleOptions.add(new SelectItemOption("125%", (Object)"1.25f"));
        scaleOptions.add(new SelectItemOption("150%", (Object)"1.5f"));
        scaleOptions.add(new SelectItemOption("200%", (Object)"2.0f"));
        scaleOptions.add(new SelectItemOption("300%", (Object)"3.0f"));
        return scaleOptions;
    }

    public static class ZoomOutPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String scale = (String)pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).getValue();
            String[] arrValue = new String[]{"0.05f", "0.1f", "0.25f", "0.5f", "0.75f", "1.0f", "1.25f", "1.5f", "2.0f", "3.0f"};
            if (scale.equals(arrValue[0])) {
                return;
            }
            for (int i = 0; i < arrValue.length - 1; ++i) {
                if (!scale.equals(arrValue[i])) continue;
                pdfViewer.setScale(Float.parseFloat(arrValue[i - 1]));
                pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).setValue(arrValue[i - 1]);
                break;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class ZoomInPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String[] arrValue = new String[]{"0.05f", "0.1f", "0.25f", "0.5f", "0.75f", "1.0f", "1.25f", "1.5f", "2.0f", "3.0f"};
            String scale = (String)pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).getValue();
            if (scale.equals(arrValue[arrValue.length - 1])) {
                return;
            }
            for (int i = 0; i < arrValue.length - 1; ++i) {
                if (!scale.equals(arrValue[i])) continue;
                pdfViewer.setScale(Float.parseFloat(arrValue[i + 1]));
                pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).setValue(arrValue[i + 1]);
                break;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class ScalePageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String scale = (String)pdfViewer.getUIFormSelectBox(PDFViewer.SCALE_PAGE).getValue();
            pdfViewer.setScale(Float.parseFloat(scale));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class RotateLeftPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            pdfViewer.setRotation(pdfViewer.currentRotation + 90.0f);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class RotateRightPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            pdfViewer.setRotation(pdfViewer.currentRotation + 270.0f);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class GotoPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            String pageStr = (String)pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).getValue();
            int pageNumber = 1;
            try {
                pageNumber = Integer.parseInt(pageStr);
            }
            catch (NumberFormatException e) {
                pageNumber = pdfViewer.currentPageNumber;
            }
            if (pageNumber >= pdfViewer.getNumberOfPages()) {
                pageNumber = pdfViewer.getNumberOfPages();
            } else if (pageNumber < 1) {
                pageNumber = 1;
            }
            pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pageNumber));
            pdfViewer.setPageNumber(pageNumber);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class NextPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            if (pdfViewer.currentPageNumber == pdfViewer.getNumberOfPages()) {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber));
            } else {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber + 1));
                pdfViewer.setPageNumber(pdfViewer.currentPageNumber + 1);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }

    public static class PreviousPageActionListener
    extends EventListener<PDFViewer> {
        public void execute(Event<PDFViewer> event) throws Exception {
            PDFViewer pdfViewer = (PDFViewer)((Object)event.getSource());
            if (pdfViewer.currentPageNumber == 1) {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber));
            } else {
                pdfViewer.getUIStringInput(PDFViewer.PAGE_NUMBER).setValue((Object)Integer.toString(pdfViewer.currentPageNumber - 1));
                pdfViewer.setPageNumber(pdfViewer.currentPageNumber - 1);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pdfViewer);
        }
    }
}

