/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.configuration;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.addons.gamification.entities.domain.configuration.AbstractAuditingEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="GamificationDomain")
@ExoEntity
@Table(name="GAMIFICATION_DOMAIN")
@NamedQueries(value={@NamedQuery(name="GamificationDomain.getAllDomains", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.isDeleted = false"), @NamedQuery(name="GamificationDomain.getEnabledDomains", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.isDeleted = false AND domain.isEnabled = true "), @NamedQuery(name="GamificationDomain.findByIdWithOwners", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.id = :id"), @NamedQuery(name="GamificationDomain.findDomainByTitle", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.title = :domainTitle"), @NamedQuery(name="GamificationDomain.deleteDomainByTitle", query="DELETE FROM GamificationDomain domain WHERE domain.title = :domainTitle")})
public class DomainEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 6578902752036385060L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_DOMAIN_ID", sequenceName="SEQ_GAMIFICATION_DOMAIN_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_DOMAIN_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="PRIORITY")
    protected int priority;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;
    @Column(name="ENABLED", nullable=false)
    protected boolean isEnabled;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    protected EntityType type;
    @Column(name="BUDGET")
    protected long budget;
    @Column(name="COVER_FILE_ID")
    protected long coverFileId;
    @Column(name="AUDIENCE_ID")
    protected Long audienceId;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="GAMIFICATION_DOMAIN_OWNERS", joinColumns={@JoinColumn(name="DOMAIN_ID")})
    @Column(name="IDENTITY_ID")
    private Set<Long> owners;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public long getBudget() {
        return this.budget;
    }

    public void setBudget(long budget) {
        this.budget = budget;
    }

    public long getCoverFileId() {
        return this.coverFileId;
    }

    public void setCoverFileId(long coverFileId) {
        this.coverFileId = coverFileId;
    }

    public Long getAudienceId() {
        return this.audienceId;
    }

    public void setAudienceId(Long audience) {
        this.audienceId = audience;
    }

    public Set<Long> getOwners() {
        return this.owners;
    }

    public void setOwners(Set<Long> owners) {
        this.owners = owners;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.budget, this.coverFileId, this.description, this.id, this.isDeleted, this.isEnabled, this.owners, this.priority, this.title, this.type});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainEntity other = (DomainEntity)obj;
        return Objects.equals(this.budget, other.budget) && Objects.equals(this.coverFileId, other.coverFileId) && Objects.equals(this.description, other.description) && Objects.equals(this.id, other.id) && this.isDeleted == other.isDeleted && this.isEnabled == other.isEnabled && Objects.equals(this.owners, other.owners) && this.priority == other.priority && Objects.equals(this.title, other.title) && this.type == other.type;
    }

    public String toString() {
        return "Domain{title='" + this.title + "', description='" + this.description + "'}";
    }
}

