/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Localized;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class TypeBuilder
implements Localized {
    private final Map<String, Object> identification;

    TypeBuilder(TypeBuilder typeBuilder) {
        this.identification = new HashMap<String, Object>(typeBuilder.identification);
    }

    TypeBuilder(Locale locale) {
        this.identification = new HashMap<String, Object>(4);
        this.putIfNonNull("locale", locale);
    }

    final void reset() {
        Object object = this.identification.get("locale");
        this.identification.clear();
        this.putIfNonNull("locale", object);
    }

    final void initialize(AbstractIdentifiedType abstractIdentifiedType) {
        this.putIfNonNull("name", abstractIdentifiedType.getName());
        this.putIfNonNull("definition", abstractIdentifiedType.getDefinition());
        this.putIfNonNull("designation", abstractIdentifiedType.getDesignation());
        this.putIfNonNull("description", abstractIdentifiedType.getDescription());
        if (abstractIdentifiedType instanceof Deprecable && abstractIdentifiedType.isDeprecated()) {
            this.identification.put("deprecated", Boolean.TRUE);
        }
    }

    private void putIfNonNull(String string, Object object) {
        if (object != null) {
            this.identification.put(string, object);
        }
    }

    final Map<String, Object> identification() {
        int n;
        String string;
        if (this.identification.get("name") == null && (string = this.getDefaultName()) != null && (n = string.length()) != 0) {
            int n2;
            int n3;
            int n4 = string.codePointAt(0);
            if (n4 != (n3 = Character.toLowerCase(n4)) && ((n2 = Character.charCount(n4)) >= n || Character.isLowerCase(string.codePointAt(n2)))) {
                StringBuilder stringBuilder = new StringBuilder(n);
                string = stringBuilder.appendCodePoint(n3).append(string, n2, n).toString();
            }
            this.identification.put("name", this.createLocalName(string));
        }
        return this.identification;
    }

    abstract void clearCache();

    abstract GenericName createLocalName(CharSequence var1);

    abstract GenericName createGenericName(CharSequence ... var1);

    public GenericName getName() {
        return (GenericName)this.identification().get("name");
    }

    String getDefaultName() {
        return null;
    }

    final String getDisplayName() {
        GenericName genericName = this.getName();
        return genericName != null ? genericName.toString() : Vocabulary.getResources(this.identification).getString((short)208);
    }

    public TypeBuilder setName(GenericName genericName) {
        this.ensureNonNull("name", genericName);
        if (!genericName.equals(this.identification.put("name", genericName))) {
            this.clearCache();
        }
        return this;
    }

    public TypeBuilder setName(CharSequence charSequence) {
        this.ensureNonEmpty("localPart", charSequence);
        return this.setName(this.createLocalName(charSequence));
    }

    public TypeBuilder setName(CharSequence ... charSequenceArray) {
        this.ensureNonNull("components", charSequenceArray);
        if (charSequenceArray.length == 0) {
            throw new IllegalArgumentException(this.errors().getString((short)29, (Object)"components"));
        }
        return this.setName(this.createGenericName(charSequenceArray));
    }

    public CharSequence getDefinition() {
        return (CharSequence)this.identification.get("definition");
    }

    public TypeBuilder setDefinition(CharSequence charSequence) {
        if (!Objects.equals(charSequence, this.identification.put("definition", charSequence))) {
            this.clearCache();
        }
        return this;
    }

    public CharSequence getDesignation() {
        return (CharSequence)this.identification.get("designation");
    }

    public TypeBuilder setDesignation(CharSequence charSequence) {
        if (!Objects.equals(charSequence, this.identification.put("designation", charSequence))) {
            this.clearCache();
        }
        return this;
    }

    public CharSequence getDescription() {
        return (CharSequence)this.identification.get("description");
    }

    public TypeBuilder setDescription(CharSequence charSequence) {
        if (!Objects.equals(charSequence, this.identification.put("description", charSequence))) {
            this.clearCache();
        }
        return this;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.identification.get("deprecated"));
    }

    public TypeBuilder setDeprecated(boolean bl) {
        Boolean bl2 = bl;
        Object object = this.identification.put("deprecated", bl2);
        if (object == null) {
            object = Boolean.FALSE;
        }
        if (!Objects.equals(bl2, object)) {
            this.clearCache();
        }
        return this;
    }

    final <E extends TypeBuilder> E forName(List<E> list, String string, boolean bl) {
        TypeBuilder typeBuilder = null;
        TypeBuilder typeBuilder2 = null;
        int n = Integer.MAX_VALUE;
        block0: for (TypeBuilder typeBuilder3 : list) {
            GenericName genericName = typeBuilder3.getName();
            int n2 = 0;
            while (genericName != null) {
                if (string.equals(genericName.toString())) {
                    if (n2 < n) {
                        typeBuilder = typeBuilder3;
                        typeBuilder2 = null;
                        n = n2;
                        continue block0;
                    }
                    if (n2 == n) {
                        typeBuilder2 = typeBuilder3;
                        continue block0;
                    }
                }
                if (!(genericName instanceof ScopedName)) continue block0;
                genericName = ((ScopedName)genericName).tail();
                ++n2;
            }
        }
        if (typeBuilder2 != null && bl) {
            throw new IllegalArgumentException(this.errors().getString((short)1, (Object)typeBuilder.getName(), (Object)typeBuilder2.getName(), (Object)string));
        }
        return (E)typeBuilder;
    }

    public Locale getLocale() {
        return (Locale)this.identification.get("locale");
    }

    final Errors errors() {
        return Errors.getResources(this.identification);
    }

    final Resources resources() {
        return Resources.forProperties(this.identification);
    }

    final void ensureNonNull(String string, Object object) {
        if (object == null) {
            throw new NullArgumentException(this.errors().getString((short)113, (Object)string));
        }
    }

    final void ensureAlive(TypeBuilder typeBuilder) {
        if (typeBuilder == null) {
            throw new IllegalStateException(this.errors().getString((short)23, this.getClass()));
        }
    }

    final void ensureNonEmpty(String string, CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullArgumentException(this.errors().getString((short)113, (Object)string));
        }
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException(this.errors().getString((short)29, (Object)string));
        }
    }

    public String toString() {
        return this.appendStringTo(new StringBuilder(Classes.getShortClassName((Object)this))).toString();
    }

    final StringBuilder appendStringTo(StringBuilder stringBuilder) {
        this.toStringInternal(stringBuilder.append("[\u201c").append(this.getDisplayName()).append('\u201d'));
        return stringBuilder.append(']');
    }

    void toStringInternal(StringBuilder stringBuilder) {
    }

    void remove() {
    }

    public abstract AbstractIdentifiedType build() throws IllegalStateException;
}

