/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profileproperty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profileproperty.ProfilePropertyDatabaseInitializer;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.profileproperty.storage.ProfileSettingStorage;
import org.picocontainer.Startable;

public class ProfilePropertyServiceImpl
implements ProfilePropertyService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ProfilePropertyServiceImpl.class);
    private final ProfileSettingStorage profileSettingStorage;
    private static final String SYNCHRONIZED_DISABLED_PROPERTIES = "synchronizationDisabledProperties";
    protected List<ProfilePropertyDatabaseInitializer> profielPropertyPlugins = new ArrayList<ProfilePropertyDatabaseInitializer>();
    private List<String> synchronizedGroupDisabledProperties = new ArrayList<String>();

    public ProfilePropertyServiceImpl(InitParams params, ProfileSettingStorage profileSettingStorage) {
        this.profileSettingStorage = profileSettingStorage;
        if (params != null) {
            try {
                this.synchronizedGroupDisabledProperties = Arrays.asList(params.getValueParam(SYNCHRONIZED_DISABLED_PROPERTIES).getValue().split(","));
            }
            catch (Exception e) {
                LOG.warn((Object)"List of disabled properties for synchronization not provided, all properties can be synchronized! ");
            }
        }
    }

    public List<ProfilePropertySetting> getPropertySettings() {
        return this.profileSettingStorage.getPropertySettings();
    }

    public List<ProfilePropertySetting> getSynchronizedPropertySettings() {
        return this.profileSettingStorage.getSynchronizedPropertySettings();
    }

    public ProfilePropertySetting getProfileSettingByName(String name) {
        return this.profileSettingStorage.findProfileSettingByName(name);
    }

    public ProfilePropertySetting getProfileSettingById(Long id) {
        return this.profileSettingStorage.getProfileSettingById(id);
    }

    public ProfilePropertySetting createPropertySetting(ProfilePropertySetting profilePropertySetting) throws ObjectAlreadyExistsException {
        if (profilePropertySetting == null) {
            throw new IllegalArgumentException("Profile property setting Item Object is mandatory");
        }
        if (StringUtils.isBlank((String)profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException("Profile property name is mandatory");
        }
        ProfilePropertySetting storedProfilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        if (storedProfilePropertySetting != null) {
            throw new ObjectAlreadyExistsException((Object)storedProfilePropertySetting, "A profile property with provided name already exist");
        }
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        if ((profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true)).getOrder() == null) {
            profilePropertySetting.setOrder(profilePropertySetting.getId());
            profilePropertySetting = this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
        }
        return profilePropertySetting;
    }

    public void updatePropertySetting(ProfilePropertySetting profilePropertySetting) {
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
    }

    public void deleteProfilePropertySetting(Long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Profile Property Setting Technical Identifier is mandatory");
        }
        this.profileSettingStorage.deleteProfilePropertySetting(id);
    }

    public boolean isGroupSynchronizedEnabledProperty(ProfilePropertySetting profilePropertySetting) {
        if (this.synchronizedGroupDisabledProperties.contains(profilePropertySetting.getPropertyName())) {
            return false;
        }
        if (profilePropertySetting.getParentId() != null && profilePropertySetting.getParentId() > 0L) {
            ProfilePropertySetting parent = this.profileSettingStorage.getProfileSettingById(profilePropertySetting.getParentId());
            return parent == null || !this.synchronizedGroupDisabledProperties.contains(parent.getPropertyName());
        }
        return true;
    }

    public List<String> getPropertySettingNames() {
        return this.getPropertySettings().stream().map(ProfilePropertySetting::getPropertyName).toList();
    }

    public void start() {
        for (ProfilePropertyDatabaseInitializer plugin : this.profielPropertyPlugins) {
            try {
                plugin.init(this);
            }
            catch (Exception ex) {
                LOG.error("Failed start Profile properties Service , probably because of configuration error. Error occurs when initializing properties for {}", new Object[]{((Object)((Object)plugin)).getClass().getName(), ex});
            }
        }
    }

    public void stop() {
    }

    public void addProfilePropertyPlugin(ComponentPlugin profilePropertyInitPlugin) {
        this.profielPropertyPlugins.add((ProfilePropertyDatabaseInitializer)profilePropertyInitPlugin);
    }

    public boolean hasChildProperties(ProfilePropertySetting propertySetting) {
        return this.profileSettingStorage.hasChildProperties(propertySetting.getId());
    }
}

