/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.register;

import javax.portlet.PortletPreferences;
import org.exoplatform.portal.webui.CaptchaValidator;
import org.exoplatform.portal.webui.register.UICaptcha;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PasswordPolicyValidator;
import org.exoplatform.webui.form.validator.PersonalNameValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.UserConfigurableValidator;

public class UIRegisterInputSet
extends UIFormInputWithActions {
    protected static String USER_NAME = "username";
    protected static String PASSWORD = "password";
    protected static String CONFIRM_PASSWORD = "confirmPassword";
    protected static String FIRST_NAME = "firstName";
    protected static String LAST_NAME = "lastName";
    protected static String DISPLAY_NAME = "displayName";
    protected static String EMAIL_ADDRESS = "emailAddress";
    protected static String CAPTCHA = "captcha";
    private boolean captchaInputAvailability;

    public UIRegisterInputSet(String name, boolean skipCaptcha) throws Exception {
        super(name);
        boolean useCaptcha;
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_NAME, USER_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(UserConfigurableValidator.class, new Object[]{"username"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PASSWORD, PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PasswordPolicyValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONFIRM_PASSWORD, CONFIRM_PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PasswordPolicyValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIRST_NAME, FIRST_NAME, null).addValidator(StringLengthValidator.class, new Object[]{1, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PersonalNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(LAST_NAME, LAST_NAME, null).addValidator(StringLengthValidator.class, new Object[]{1, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PersonalNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DISPLAY_NAME, DISPLAY_NAME, null).addValidator(StringLengthValidator.class, new Object[]{0, 90}).addValidator(UserConfigurableValidator.class, new Object[]{"displayname", "gatein.validators.displayname", false}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(EMAIL_ADDRESS, EMAIL_ADDRESS, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(UserConfigurableValidator.class, new Object[]{"email"}));
        if (skipCaptcha) {
            useCaptcha = false;
        } else {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            useCaptcha = Boolean.parseBoolean(pref.getValue("useCaptcha", "true"));
        }
        if (useCaptcha) {
            this.addUIFormInput((UIFormInput)new UICaptcha(CAPTCHA, CAPTCHA, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(CaptchaValidator.class, new Object[0]));
            this.captchaInputAvailability = true;
        }
    }

    public void setCaptchaInputAvailability(boolean availability) {
        this.captchaInputAvailability = availability;
    }

    public boolean getCaptchaInputAvailability() {
        return this.captchaInputAvailability;
    }

    private String getUserName() {
        return (String)this.getUIStringInput(USER_NAME).getValue();
    }

    private String getEmail() {
        return (String)this.getUIStringInput(EMAIL_ADDRESS).getValue();
    }

    private String getPassword() {
        return (String)this.getUIStringInput(PASSWORD).getValue();
    }

    private String getFirstName() {
        return (String)this.getUIStringInput(FIRST_NAME).getValue();
    }

    private String getLastName() {
        return (String)this.getUIStringInput(LAST_NAME).getValue();
    }

    private String getDisplayName() {
        return (String)this.getUIStringInput(DISPLAY_NAME).getValue();
    }

    private void bindingFields(User user) {
        user.setPassword(this.getPassword());
        user.setFirstName(this.getFirstName());
        user.setLastName(this.getLastName());
        user.setFullName(this.getDisplayName());
        user.setEmail(this.getEmail());
    }

    public boolean save(UserHandler userHandler, WebuiRequestContext context) throws Exception {
        String confirm_pass;
        UIApplication uiApp = context.getUIApplication();
        String pass = this.getPassword();
        if (!pass.equals(confirm_pass = (String)this.getUIStringInput(CONFIRM_PASSWORD).getValue())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountForm.msg.password-is-not-match", null));
            return false;
        }
        String username = this.getUserName();
        if (userHandler.findUserByName(username, UserStatus.ANY) != null) {
            Object[] args = new Object[]{username};
            uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.user-exist", args));
            return false;
        }
        Query query = new Query();
        query.setEmail(this.getEmail());
        if (userHandler.findUsersByQuery(query, UserStatus.ANY).getSize() > 0) {
            Object[] args = new Object[]{username};
            uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.email-exist", args));
            return false;
        }
        User user = userHandler.createUserInstance(username);
        this.bindingFields(user);
        try {
            userHandler.createUser(user, true);
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.fail.create.user", null, 0));
            return false;
        }
        this.reset();
        context.setAttribute("UIRegisterForm$User", (Object)user);
        return true;
    }
}

