/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.PropertiesClassLoader;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.BaseResourceBundlePlugin;
import org.picocontainer.Startable;

public abstract class BaseResourceBundleService
implements ResourceBundleService,
Startable {
    protected Log log_;
    protected ClassLoader cl;
    protected List<String> localeList_ = Collections.synchronizedList(new ArrayList());
    protected volatile List<String> classpathResources_;
    protected volatile String[] portalResourceBundleNames_;
    protected LocaleConfigService localeService_;
    protected ExoCache<String, ResourceBundle> cache_;
    protected PortalContainer portalContainer_;
    private volatile FutureCache<String, ResourceBundle, ResourceBundleContext> futureCache_;
    private final Loader<String, ResourceBundle, ResourceBundleContext> loader_ = new Loader<String, ResourceBundle, ResourceBundleContext>(){

        public ResourceBundle retrieve(ResourceBundleContext context, String key) throws Exception {
            ResourceBundle resourceBundle = context.get(key);
            return resourceBundle == null ? ExoResourceBundle.NULL_OBJECT : resourceBundle;
        }
    };
    private volatile List<String> initResources_;

    protected void initParams(InitParams params) {
        this.classpathResources_ = params.getValuesParam("classpath.resources").getValues();
        List prnames = params.getValuesParam("portal.resource.names").getValues();
        this.portalResourceBundleNames_ = new String[prnames.size()];
        for (int i = 0; i < prnames.size(); ++i) {
            this.portalResourceBundleNames_[i] = (String)prnames.get(i);
        }
        this.initResources_ = params.getValuesParam("init.resources").getValues();
    }

    public synchronized void addResourceBundle(BaseResourceBundlePlugin plugin) {
        List<String> initResources;
        List<String> portalResources;
        List<String> classpathResources = plugin.getClasspathResources();
        if (classpathResources != null && !classpathResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(classpathResources);
            if (this.classpathResources_ != null) {
                result.addAll(this.classpathResources_);
            }
            this.classpathResources_ = Collections.unmodifiableList(result);
        }
        if ((portalResources = plugin.getPortalResources()) != null && !portalResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(portalResources);
            if (this.portalResourceBundleNames_ != null) {
                result.addAll(Arrays.asList(this.portalResourceBundleNames_));
            }
            this.portalResourceBundleNames_ = result.toArray(new String[result.size()]);
        }
        if ((initResources = plugin.getInitResources()) != null && !initResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(initResources);
            if (this.initResources_ != null) {
                result.addAll(this.initResources_);
            }
            this.initResources_ = Collections.unmodifiableList(result);
        }
    }

    public void start() {
        PageList pl = null;
        try {
            pl = this.findResourceDescriptions(new Query(null, null));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot check if a resource already exists", e);
        }
        if (pl.getAvailable() > 0) {
            return;
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        List<String> initResources = this.initResources_;
        final Collection localeConfigs = this.localeService_.getLocalConfigs();
        this.loadResourcesForLocale(this.localeService_.getDefaultLocaleConfig().getLocale());
        PortalContainer.addInitTask((ServletContext)this.portalContainer_.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (LocaleConfig localeConfig : localeConfigs) {
                            if (BaseResourceBundleService.this.localeList_.contains(localeConfig.getLocale().getLanguage())) continue;
                            BaseResourceBundleService.this.loadResourcesForLocale(localeConfig.getLocale());
                        }
                    }
                }, "ResourceBundleThread").start();
            }
        });
    }

    public void stop() {
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    public ResourceBundle getResourceBundle(String name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    public String[] getSharedResourceBundleNames() {
        return this.portalResourceBundleNames_;
    }

    public ResourceBundleData createResourceBundleDataInstance() {
        return new ResourceBundleData();
    }

    protected boolean isClasspathResource(String name) {
        if (this.classpathResources_ == null) {
            return false;
        }
        for (int i = 0; i < this.classpathResources_.size(); ++i) {
            String pack = this.classpathResources_.get(i);
            if (!name.startsWith(pack)) continue;
            return true;
        }
        return false;
    }

    protected void initResources(String baseName, Locale locale, ClassLoader cl) {
        String name = baseName.replace('.', '/');
        try {
            Locale defaultLocale = this.localeService_.getDefaultLocaleConfig().getLocale();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            String content = this.getResourceBundleContent(name, locale, defaultLocale, cl);
            if (content != null) {
                ResourceBundleData data = new ResourceBundleData();
                data.setName(baseName);
                data.setLanguage(language);
                data.setCountry(country);
                data.setVariant(variant);
                data.setData(content);
                this.saveResourceBundle(data);
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("Error while reading the resource bundle : " + baseName), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceBundleContent(String name, String language, String defaultLang, ClassLoader cl) throws Exception {
        block10: {
            String string;
            String fileName = null;
            cl = new PropertiesClassLoader(cl, true);
            fileName = name + "_" + language + ".properties";
            URL url = cl.getResource(fileName);
            if (url == null && defaultLang.equals(language)) {
                url = cl.getResource(name + ".properties");
            }
            if (url == null) break block10;
            InputStream is = url.openStream();
            try {
                byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                string = new String(buf, "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Exception("Error while reading the file: " + fileName, e);
                }
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceBundleContent(String baseName, Locale locale, Locale defaultLocale, ClassLoader cl) throws Exception {
        block16: {
            String string;
            ArrayList<CallSite> candidateFiles = new ArrayList<CallSite>();
            String language = locale.getLanguage();
            String country = locale.getCountry().toUpperCase();
            String variant = locale.getVariant();
            String defaultLanguage = defaultLocale.getLanguage();
            String defaultCountry = defaultLocale.getCountry().toUpperCase();
            String defaultVariant = defaultLocale.getVariant();
            if (variant != null && variant.length() > 0) {
                candidateFiles.add((CallSite)((Object)(baseName + "_" + language + "_" + country + "_" + variant + ".properties")));
            }
            if (country != null && country.length() > 0) {
                candidateFiles.add((CallSite)((Object)(baseName + "_" + language + "_" + country + ".properties")));
            }
            if (language != null && language.length() > 0) {
                candidateFiles.add((CallSite)((Object)(baseName + "_" + language + ".properties")));
            }
            if (defaultVariant != null && defaultVariant.length() > 0) {
                candidateFiles.add((CallSite)((Object)(baseName + "_" + defaultLanguage + "_" + defaultCountry + "_" + defaultVariant + ".properties")));
            }
            if (defaultCountry != null && defaultCountry.length() > 0) {
                candidateFiles.add((CallSite)((Object)(baseName + "_" + defaultLanguage + "_" + defaultCountry + ".properties")));
            }
            if (defaultLanguage != null && defaultLanguage.length() > 0) {
                candidateFiles.add((CallSite)((Object)(baseName + "_" + defaultLanguage + ".properties")));
            }
            candidateFiles.add((CallSite)((Object)(baseName + ".properties")));
            candidateFiles.add((CallSite)((Object)(baseName + "_" + Locale.ENGLISH.getLanguage() + ".properties")));
            cl = new PropertiesClassLoader(cl, true);
            String fileName = null;
            URL url = null;
            for (String string2 : candidateFiles) {
                url = cl.getResource(string2);
                if (url == null) continue;
                fileName = string2;
                break;
            }
            if (url == null) break block16;
            InputStream is = url.openStream();
            try {
                byte[] byArray = IOUtil.getStreamContentAsBytes((InputStream)is);
                string = new String(byArray, "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new Exception("Error while reading the file: " + fileName, ex);
                }
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        return null;
    }

    protected List<String> getInitResources_() {
        return this.initResources_;
    }

    protected void loadResourcesForLocale(Locale locale) {
        for (String resource : this.getInitResources_()) {
            this.initResources(resource, locale, this.cl);
        }
        this.localeList_.add(locale.getLanguage());
    }

    protected final void invalidate(String name) {
        this.cache_.remove((Serializable)((Object)name));
    }

    public ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader cl) {
        boolean isCacheable;
        if (IdentityResourceBundle.MAGIC_LANGUAGE.equals(locale.getLanguage())) {
            return IdentityResourceBundle.getInstance();
        }
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String id = variant != null && variant.length() > 0 ? name + "_" + locale.getLanguage() + "_" + country + "_" + variant : (country != null && country.length() > 0 ? name + "_" + locale.getLanguage() + "_" + locale.getCountry() : name + "_" + locale.getLanguage());
        boolean isClasspathResource = this.isClasspathResource(name);
        boolean bl = isCacheable = !isClasspathResource || !PropertyManager.isDevelopping();
        if (isCacheable && isClasspathResource) {
            id = id + "_" + cl.getClass() + "_" + System.identityHashCode(cl);
        }
        if (isClasspathResource) {
            ResourceBundleFromCPContext ctx = new ResourceBundleFromCPContext(name, locale, cl);
            ResourceBundle result = isCacheable ? (ResourceBundle)this.getFutureCache().get((Object)ctx, (Object)id) : ctx.get(id);
            if (ctx.e != null) {
                throw ctx.e;
            }
            return result == ExoResourceBundle.NULL_OBJECT ? null : result;
        }
        ResourceBundle resourceBundle = (ResourceBundle)this.getFutureCache().get((Object)new GetResourceBundleFromDbContext(name, locale), (Object)id);
        return resourceBundle == ExoResourceBundle.NULL_OBJECT ? null : resourceBundle;
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale, ClassLoader cl) {
        if (IdentityResourceBundle.MAGIC_LANGUAGE.equals(locale.getLanguage())) {
            return IdentityResourceBundle.getInstance();
        }
        StringBuilder idBuf = new StringBuilder("merge:");
        for (String n : name) {
            idBuf.append(n).append("_");
        }
        idBuf.append(locale);
        String id = idBuf.toString();
        return (ResourceBundle)this.getFutureCache().get((Object)new GetResourceBundleContext(name, locale, cl), (Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FutureCache<String, ResourceBundle, ResourceBundleContext> getFutureCache() {
        if (this.futureCache_ == null) {
            BaseResourceBundleService baseResourceBundleService = this;
            synchronized (baseResourceBundleService) {
                if (this.futureCache_ == null) {
                    this.futureCache_ = new FutureExoCache<String, ResourceBundle, ResourceBundleContext>(this.loader_, this.cache_){

                        public ResourceBundle get(String key) {
                            ResourceBundle resourceBundle = (ResourceBundle)super.get((Serializable)((Object)key));
                            return resourceBundle == ExoResourceBundle.NULL_OBJECT ? null : resourceBundle;
                        }
                    };
                }
            }
        }
        return this.futureCache_;
    }

    protected abstract ResourceBundle getResourceBundleFromDb(String var1, ResourceBundle var2, Locale var3) throws Exception;

    private class ResourceBundleFromCPContext
    extends ResourceBundleContext {
        private final String name;
        private final Locale locale;
        private final ClassLoader cl;
        private RuntimeException e;

        public ResourceBundleFromCPContext(String name, Locale locale, ClassLoader cl) {
            this.name = name;
            this.locale = locale;
            this.cl = cl;
        }

        @Override
        ResourceBundle get(String id) {
            ResourceBundle parent = null;
            ResourceBundle result = null;
            try {
                Locale defaultLocale = BaseResourceBundleService.this.localeService_.getDefaultLocaleConfig().getLocale();
                String rootId = this.name + "_" + defaultLocale.getLanguage();
                parent = this.getContent(rootId, null, defaultLocale);
                result = this.getContent(this.name, parent, defaultLocale);
            }
            catch (Exception e) {
                this.e = new RuntimeException(e);
            }
            if (result != null) {
                return result;
            }
            return parent == null ? ExoResourceBundle.NULL_OBJECT : parent;
        }

        private ResourceBundle getContent(String _name, ResourceBundle parent, Locale defaultLocale) throws Exception {
            String content = BaseResourceBundleService.this.getResourceBundleContent(_name.replace('.', '/'), this.locale, defaultLocale, this.cl);
            if (content != null) {
                ResourceBundleData data = new ResourceBundleData();
                data.setName(_name);
                data.setLanguage(this.locale.getLanguage());
                data.setCountry(this.locale.getCountry());
                data.setVariant(this.locale.getVariant());
                data.setData(content);
                return new ExoResourceBundle(data, parent);
            }
            return null;
        }
    }

    private class GetResourceBundleFromDbContext
    extends ResourceBundleContext {
        private final String name;
        private final Locale locale;

        public GetResourceBundleFromDbContext(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }

        @Override
        ResourceBundle get(String id) {
            ResourceBundle res = null;
            if (!BaseResourceBundleService.this.localeList_.contains(this.locale.getLanguage())) {
                BaseResourceBundleService.this.loadResourcesForLocale(this.locale);
            }
            try {
                String rootId = this.name + "_" + BaseResourceBundleService.this.localeService_.getDefaultLocaleConfig().getLanguage();
                ResourceBundle parent = BaseResourceBundleService.this.getResourceBundleFromDb(rootId, null, this.locale);
                res = BaseResourceBundleService.this.getResourceBundleFromDb(id, parent, this.locale);
                if (res == null) {
                    res = parent;
                }
            }
            catch (Exception ex) {
                BaseResourceBundleService.this.log_.error((Object)("Error: " + id), (Throwable)ex);
            }
            return res;
        }
    }

    private class GetResourceBundleContext
    extends ResourceBundleContext {
        private final String[] name;
        private final Locale locale;
        private final ClassLoader cl;

        public GetResourceBundleContext(String[] name, Locale locale, ClassLoader cl) {
            this.name = name;
            this.locale = locale;
            this.cl = cl;
        }

        @Override
        ResourceBundle get(String id) {
            MapResourceBundle outputBundled = null;
            try {
                outputBundled = new MapResourceBundle(this.locale);
                for (int i = 0; i < this.name.length; ++i) {
                    ResourceBundle temp;
                    if (!BaseResourceBundleService.this.localeList_.contains(this.locale.getLanguage())) {
                        BaseResourceBundleService.this.loadResourcesForLocale(this.locale);
                    }
                    if ((temp = BaseResourceBundleService.this.getResourceBundle(this.name[i], this.locale, this.cl)) != null) {
                        outputBundled.merge(temp);
                        continue;
                    }
                    BaseResourceBundleService.this.log_.warn((Object)("Cannot load and merge the bundle: " + this.name[i]));
                }
                outputBundled.resolveDependencies();
            }
            catch (Exception ex) {
                BaseResourceBundleService.this.log_.error((Object)("Cannot load and merge the bundle: " + id), (Throwable)ex);
            }
            return outputBundled;
        }
    }

    private static abstract class ResourceBundleContext {
        private ResourceBundleContext() {
        }

        abstract ResourceBundle get(String var1);
    }
}

