/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class PortalFolderSchemaHandler
extends BaseWebSchemaHandler {
    public Node getCSSFolder(Node portalFolder) throws Exception {
        return portalFolder.hasNode("css") ? portalFolder.getNode("css") : null;
    }

    public Node getJSFolder(Node portalFolder) throws Exception {
        return portalFolder.hasNode("js") ? portalFolder.getNode("js") : null;
    }

    public Node getMultimediaFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias");
    }

    public Node getImagesFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/images");
    }

    public Node getVideoFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/videos");
    }

    public Node getAudioFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/audio");
    }

    public Node getDocumentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("documents");
    }

    public Node getLinkFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("links");
    }

    public Node getWebContentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents");
    }

    @Override
    protected String getHandlerNodeType() {
        return "exo:portalFolder";
    }

    @Override
    protected String getParentNodeType() {
        return "nt:unstructured";
    }

    protected void updateNode(Node node) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.addMixin(node, "exo:owneable");
        this.addMixin(node, "exo:datetime");
        this.addMixin(node, "exo:modify");
        this.addMixin(node, "exo:sortable");
        node.setProperty("exo:dateCreated", (Calendar)new GregorianCalendar());
        node.setProperty("exo:lastModifiedDate", (Calendar)new GregorianCalendar());
        ConversationState conversationState = ConversationState.getCurrent();
        String userName = conversationState == null ? node.getSession().getUserID() : conversationState.getIdentity().getUserId();
        node.setProperty("exo:lastModifier", userName);
        node.setProperty("exo:name", node.getName());
    }

    @Override
    public void onCreateNode(SessionProvider sessionProvider, Node portalFolder) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        if (!portalFolder.hasNode("js")) {
            Node jsFolder = portalFolder.addNode("js", "exo:jsFolder");
            this.updateNode(jsFolder);
        }
        if (!portalFolder.hasNode("css")) {
            Node cssFolder = portalFolder.addNode("css", "exo:cssFolder");
            this.updateNode(cssFolder);
        }
        if (!portalFolder.hasNode("medias")) {
            Node multimedia = portalFolder.addNode("medias", "exo:multimediaFolder");
            this.updateNode(multimedia);
            Node images = multimedia.addNode("images", "nt:folder");
            this.addMixin(images, "exo:pictureFolder");
            this.updateNode(images);
            Node video = multimedia.addNode("videos", "nt:folder");
            this.addMixin(video, "exo:videoFolder");
            this.updateNode(video);
            Node audio = multimedia.addNode("audio", "nt:folder");
            this.addMixin(audio, "exo:musicFolder");
            this.updateNode(audio);
        }
        if (!portalFolder.hasNode("documents")) {
            Node document = portalFolder.addNode("documents", "nt:unstructured");
            this.addMixin(document, "exo:documentFolder");
            this.updateNode(document);
            document.addMixin("exo:privilegeable");
            ((ExtendedNode)document).setPermission(IdentityConstants.ANY, PermissionType.ALL);
        }
        if (!portalFolder.hasNode("web contents")) {
            Node webContents = portalFolder.addNode("web contents", "exo:webFolder");
            this.updateNode(webContents);
            Node themes = webContents.addNode("site artifacts", "exo:themeFolder");
            this.updateNode(themes);
        }
        if (!portalFolder.hasNode("links")) {
            Node links = portalFolder.addNode("links", "exo:linkFolder");
            this.updateNode(links);
        }
        if (!portalFolder.hasNode("categories")) {
            Node categoryFolder = portalFolder.addNode("categories", "nt:unstructured");
            this.updateNode(categoryFolder);
        }
        if (!portalFolder.hasNode("ApplicationData")) {
            Node applicationDataFolder = portalFolder.addNode("ApplicationData", "nt:unstructured");
            this.updateNode(applicationDataFolder);
            this.addMixin(applicationDataFolder, "exo:hiddenable");
            Node newsletterApplicationFolder = applicationDataFolder.addNode("NewsletterApplication", "nt:unstructured");
            this.updateNode(newsletterApplicationFolder);
            Node defaultTemplatesFolder = newsletterApplicationFolder.addNode("DefaultTemplates", "nt:unstructured");
            this.updateNode(defaultTemplatesFolder);
            Node newsletterCategoriesFolder = newsletterApplicationFolder.addNode("Categories", "nt:unstructured");
            this.updateNode(newsletterCategoriesFolder);
            Node newsletterUserFolder = newsletterApplicationFolder.addNode("Users", "nt:unstructured");
            this.updateNode(newsletterUserFolder);
        }
        portalFolder.getSession().save();
    }
}

