/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLIndexHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.SQLServerHints;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Database;
import liquibase.repackaged.net.sf.jsqlparser.schema.MultiPartName;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.IntoTableVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;

public class Table
extends ASTNodeAccessImpl
implements MultiPartName,
FromItem {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();
    private Alias alias;
    private Pivot pivot;
    private UnPivot unpivot;
    private MySQLIndexHint mysqlHints;
    private SQLServerHints sqlServerHints;

    public Table() {
    }

    public Table(String string) {
        this.setName(string);
    }

    public Table(String string, String string2) {
        this.setName(string2);
        this.setSchemaName(string);
    }

    public Table(Database database, String string, String string2) {
        this.setName(string2);
        this.setSchemaName(string);
        this.setDatabase(database);
    }

    public Table(List<String> list) {
        this.partItems = new ArrayList<String>(list);
        Collections.reverse(this.partItems);
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public Table withDatabase(Database database) {
        this.setDatabase(database);
        return this;
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
        if (database.getServer() != null) {
            this.setIndex(3, database.getServer().getFullyQualifiedName());
        }
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public Table withSchemaName(String string) {
        this.setSchemaName(string);
        return this;
    }

    public void setSchemaName(String string) {
        this.setIndex(1, string);
    }

    public String getName() {
        return this.getIndex(0);
    }

    public Table withName(String string) {
        this.setName(string);
        return this;
    }

    public void setName(String string) {
        this.setIndex(0, string);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    private void setIndex(int n2, String string) {
        int n3 = this.partItems.size();
        for (int i2 = 0; i2 < n2 - n3 + 1; ++i2) {
            this.partItems.add(null);
        }
        if (string == null && n2 == this.partItems.size() - 1) {
            this.partItems.remove(n2);
            return;
        }
        this.partItems.set(n2, string);
    }

    private String getIndex(int n2) {
        if (n2 < this.partItems.size()) {
            return this.partItems.get(n2);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = this.partItems.size() - 1; i2 >= 0; --i2) {
            String string = this.partItems.get(i2);
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
            if (i2 == 0) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public void accept(IntoTableVisitor intoTableVisitor) {
        intoTableVisitor.visit(this);
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unpivot;
    }

    @Override
    public void setUnPivot(UnPivot unPivot) {
        this.unpivot = unPivot;
    }

    public MySQLIndexHint getIndexHint() {
        return this.mysqlHints;
    }

    public Table withHint(MySQLIndexHint mySQLIndexHint) {
        this.setHint(mySQLIndexHint);
        return this;
    }

    public void setHint(MySQLIndexHint mySQLIndexHint) {
        this.mysqlHints = mySQLIndexHint;
    }

    public SQLServerHints getSqlServerHints() {
        return this.sqlServerHints;
    }

    public void setSqlServerHints(SQLServerHints sQLServerHints) {
        this.sqlServerHints = sQLServerHints;
    }

    public String toString() {
        return this.getFullyQualifiedName() + (this.alias != null ? this.alias.toString() : "") + (this.pivot != null ? " " + this.pivot : "") + (this.unpivot != null ? " " + this.unpivot : "") + (this.mysqlHints != null ? this.mysqlHints.toString() : "") + (this.sqlServerHints != null ? this.sqlServerHints.toString() : "");
    }

    @Override
    public Table withUnPivot(UnPivot unPivot) {
        return (Table)FromItem.super.withUnPivot(unPivot);
    }

    @Override
    public Table withAlias(Alias alias) {
        return (Table)FromItem.super.withAlias(alias);
    }

    @Override
    public Table withPivot(Pivot pivot) {
        return (Table)FromItem.super.withPivot(pivot);
    }

    public Table withSqlServerHints(SQLServerHints sQLServerHints) {
        this.setSqlServerHints(sQLServerHints);
        return this;
    }
}

