/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class PostActivityPlugin
extends BaseNotificationPlugin {
    public static final String ID = "PostActivityPlugin";

    public PostActivityPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        try {
            ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
            String receiver = activity.getStreamOwner();
            if (Utils.getActivityManager().isNotificationEnabled(activity, receiver)) {
                String poster = Utils.getUserId(activity.getPosterId());
                return NotificationInfo.instance().to(receiver).setFrom(poster).with(SocialNotificationUtils.POSTER.getKey(), poster).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).key(this.getId()).end();
            }
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
        }
        return null;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        return Utils.getActivityManager().isNotificationEnabled(activity) && !activity.getStreamOwner().equals(Utils.getUserId(activity.getPosterId())) && !Utils.isSpaceActivity(activity);
    }
}

