/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class GamificationGenericListener
extends Listener<Map<String, String>, String> {
    private static final Log LOG = ExoLogger.getLogger(GamificationGenericListener.class);
    public static final String GENERIC_EVENT_NAME = "exo.gamification.generic.action";
    public static final String CANCEL_EVENT_NAME = "gamification.cancel.event.action";
    public static final String DELETE_EVENT_NAME = "gamification.delete.event.action";
    protected PortalContainer container;
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected RealizationService realizationService;

    public GamificationGenericListener(PortalContainer container, RuleService ruleService, IdentityManager identityManager, RealizationService realizationService) {
        this.container = container;
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.realizationService = realizationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(Event<Map<String, String>, String> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String gamificationEventId = (String)((Map)event.getSource()).get("eventId");
            if (StringUtils.isBlank((CharSequence)gamificationEventId)) {
                gamificationEventId = (String)((Map)event.getSource()).get("ruleTitle");
            }
            String senderId = (String)((Map)event.getSource()).get("senderId");
            String senderType = (String)((Map)event.getSource()).get("senderType");
            String receiverId = (String)((Map)event.getSource()).get("receiverId");
            String receiverType = (String)((Map)event.getSource()).get("receiverType");
            String objectId = (String)((Map)event.getSource()).get("objectId");
            String objectType = (String)((Map)event.getSource()).get("objectType");
            Identity senderIdentity = this.getIdentity(senderType, senderId);
            Identity receiverIdentity = this.getIdentity(receiverType, receiverId);
            switch (event.getEventName()) {
                case "exo.gamification.generic.action": {
                    this.realizationService.createRealizationsAsync(gamificationEventId, senderIdentity != null ? senderIdentity.getId() : null, receiverIdentity != null ? receiverIdentity.getId() : null, objectId, objectType);
                    return;
                }
                case "gamification.delete.event.action": {
                    this.realizationService.deleteRealizations(objectId, objectType);
                    return;
                }
                case "gamification.cancel.event.action": {
                    this.realizationService.cancelRealizations(gamificationEventId, senderIdentity != null ? senderIdentity.getId() : null, receiverIdentity != null ? receiverIdentity.getId() : null, objectId, objectType);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected listener event name: " + event.getEventName());
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private Identity getIdentity(String identityType, String identityId) {
        String providerId = IdentityType.getType(identityType).getProviderId();
        Identity identity = this.identityManager.getOrCreateIdentity(providerId, identityId);
        if (identity == null && NumberUtils.isDigits((String)identityId)) {
            identity = this.identityManager.getIdentity(identityId);
        }
        if (identity == null) {
            LOG.info("Can't find identity with identityId = {}", new Object[]{identityId});
            return null;
        }
        return identity;
    }
}

