/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.client.ext.AckExtension;
import org.cometd.client.http.jetty.JettyHttpClientTransport;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.websocket.javax.WebSocketTransport;
import org.cometd.common.JSONContext;
import org.cometd.oort.OortComet;
import org.cometd.oort.OortMembership;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.ext.BinaryExtension;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="CometD cloud node")
public class Oort
extends ContainerLifeCycle {
    public static final String OORT_ATTRIBUTE = Oort.class.getName();
    public static final String EXT_OORT_FIELD = "org.cometd.oort";
    public static final String EXT_OORT_URL_FIELD = "oortURL";
    public static final String EXT_OORT_ID_FIELD = "oortId";
    public static final String EXT_OORT_SECRET_FIELD = "oortSecret";
    public static final String EXT_COMET_URL_FIELD = "cometURL";
    public static final String EXT_OORT_ALIAS_URL_FIELD = "oortAliasURL";
    public static final String OORT_CLOUD_CHANNEL = "/oort/cloud";
    public static final String OORT_SERVICE_CHANNEL = "/service/oort";
    static final String COMET_URL_ATTRIBUTE = "org.cometd.oort.cometURL";
    private static final List<String> PROTECTED_CHANNELS = Arrays.asList("/oort/**", "/oort/*", "/service/oort/**", "/service/oort/*", "/service/oort");
    private final ConcurrentMap<String, Boolean> _channels = new ConcurrentHashMap<String, Boolean>();
    private final CopyOnWriteArrayList<CometListener> _cometListeners = new CopyOnWriteArrayList();
    private final ServerChannel.MessageListener _cloudListener = new CloudListener();
    private final List<ClientTransport.Factory> _transportFactories = new ArrayList<ClientTransport.Factory>();
    private final BayeuxServer.SubscriptionListener _allChannelsFilter = new AllChannelsFilter();
    private final OortAuthorizer _authorizer = new OortAuthorizer();
    private final BayeuxServer _bayeux;
    private final String _url;
    private final String _id;
    private final Logger _logger;
    private final LocalSession _oortSession;
    private final OortMembership _membership;
    private ScheduledExecutorService _scheduler;
    private String _secret;
    private boolean _ackExtensionEnabled = true;
    private BayeuxServer.Extension _ackExtension;
    private boolean _binaryExtensionEnabled;
    private BayeuxServer.Extension _serverBinaryExtension;
    private ClientSession.Extension _binaryExtension;
    private JSONContext.Client _jsonContext;

    public Oort(BayeuxServer bayeux, String url) {
        this._bayeux = bayeux;
        this._url = url;
        this._id = UUID.randomUUID().toString();
        this._logger = LoggerFactory.getLogger((String)Oort.loggerName(((Object)((Object)this)).getClass(), url, null));
        this._oortSession = bayeux.newLocalSession("oort");
        this._membership = new OortMembership(this);
        this.addBean((Object)this._membership);
        this._secret = Long.toHexString(new SecureRandom().nextLong());
    }

    protected void doStart() throws Exception {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        this._scheduler = scheduler;
        if (this._transportFactories.isEmpty()) {
            this._transportFactories.add((ClientTransport.Factory)new WebSocketTransport.Factory());
            this._transportFactories.add((ClientTransport.Factory)new JettyHttpClientTransport.Factory(new HttpClient()));
        }
        for (ClientTransport.Factory factory : this._transportFactories) {
            this.addBean(factory);
        }
        if (this.isAckExtensionEnabled()) {
            boolean present = false;
            for (BayeuxServer.Extension extension : this._bayeux.getExtensions()) {
                if (!(extension instanceof AcknowledgedMessagesExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                this._ackExtension = new AcknowledgedMessagesExtension();
                this._bayeux.addExtension(this._ackExtension);
            }
        }
        if (this.isBinaryExtensionEnabled()) {
            this._binaryExtension = new org.cometd.client.ext.BinaryExtension();
            this._oortSession.addExtension(this._binaryExtension);
            boolean present = false;
            for (BayeuxServer.Extension extension : this._bayeux.getExtensions()) {
                if (!(extension instanceof BinaryExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                this._serverBinaryExtension = new BinaryExtension();
                this._bayeux.addExtension(this._serverBinaryExtension);
            }
        }
        this._bayeux.addListener((BayeuxServer.BayeuxServerListener)this._allChannelsFilter);
        ServerChannel oortCloudChannel = (ServerChannel)this._bayeux.createChannelIfAbsent(OORT_CLOUD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        oortCloudChannel.addListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
        this._oortSession.handshake();
        this.protectOortChannels(this._bayeux);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.unprotectOortChannels(this._bayeux);
        this._oortSession.disconnect();
        this._oortSession.removeExtension(this._binaryExtension);
        ServerChannel channel = this._bayeux.getChannel(OORT_CLOUD_CHANNEL);
        if (channel != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this._cloudListener);
        }
        this._bayeux.removeListener((BayeuxServer.BayeuxServerListener)this._allChannelsFilter);
        BayeuxServer.Extension binaryExtension = this._serverBinaryExtension;
        this._serverBinaryExtension = null;
        if (binaryExtension != null) {
            this._bayeux.removeExtension(binaryExtension);
        }
        BayeuxServer.Extension ackExtension = this._ackExtension;
        this._ackExtension = null;
        if (ackExtension != null) {
            this._bayeux.removeExtension(ackExtension);
        }
        this._channels.clear();
        this._scheduler.shutdown();
        for (ClientTransport.Factory factory : this._transportFactories) {
            this.removeBean(factory);
        }
    }

    protected void protectOortChannels(BayeuxServer bayeux) {
        PROTECTED_CHANNELS.forEach(name -> bayeux.createChannelIfAbsent(name, new ConfigurableServerChannel.Initializer[]{channel -> channel.addAuthorizer((Authorizer)this._authorizer)}));
    }

    protected void unprotectOortChannels(BayeuxServer bayeux) {
        PROTECTED_CHANNELS.forEach(name -> {
            ServerChannel channel = bayeux.getChannel(name);
            if (channel != null) {
                channel.removeAuthorizer((Authorizer)this._authorizer);
            }
        });
    }

    protected ScheduledExecutorService getScheduler() {
        return this._scheduler;
    }

    @ManagedAttribute(value="The BayeuxServer of this Oort", readonly=true)
    public BayeuxServer getBayeuxServer() {
        return this._bayeux;
    }

    @ManagedAttribute(value="The URL of this Oort", readonly=true)
    public String getURL() {
        return this._url;
    }

    @ManagedAttribute(value="The unique ID of this Oort", readonly=true)
    public String getId() {
        return this._id;
    }

    @ManagedAttribute(value="The secret of this Oort")
    public String getSecret() {
        return this._secret;
    }

    public void setSecret(String secret) {
        this._secret = secret;
    }

    @ManagedAttribute(value="Whether the acknowledgement extension is enabled")
    public boolean isAckExtensionEnabled() {
        return this._ackExtensionEnabled;
    }

    public void setAckExtensionEnabled(boolean value) {
        this._ackExtensionEnabled = value;
    }

    @ManagedAttribute(value="Whether the binary extension is enabled")
    public boolean isBinaryExtensionEnabled() {
        return this._binaryExtensionEnabled;
    }

    public void setBinaryExtensionEnabled(boolean value) {
        this._binaryExtensionEnabled = value;
    }

    public JSONContext.Client getJSONContextClient() {
        return this._jsonContext;
    }

    public void setJSONContextClient(JSONContext.Client jsonContext) {
        this._jsonContext = jsonContext;
    }

    public List<ClientTransport.Factory> getClientTransportFactories() {
        return this._transportFactories;
    }

    public void setClientTransportFactories(List<ClientTransport.Factory> factories) {
        this._transportFactories.clear();
        this._transportFactories.addAll(factories);
    }

    public OortComet observeComet(String cometURL) {
        return this._membership.observeComet(cometURL);
    }

    protected OortComet newOortComet(String cometURL) {
        String maxNetworkDelayOption;
        String idleTimeoutOption;
        Object maxMessageSizeOption;
        Object option;
        HashMap<Object, Object> options = new HashMap<Object, Object>(2);
        options.put("scheduler", this._scheduler);
        JSONContext.Client jsonContext = this.getJSONContextClient();
        if (jsonContext != null) {
            options.put("jsonContext", jsonContext);
        }
        if ((option = this._bayeux.getOption((String)(maxMessageSizeOption = "maxMessageSize"))) != null) {
            options.put(maxMessageSizeOption, option);
        }
        if ((option = this._bayeux.getOption((String)(maxMessageSizeOption = "ws." + (String)maxMessageSizeOption))) != null) {
            options.put(maxMessageSizeOption, option);
        }
        if ((option = this._bayeux.getOption(idleTimeoutOption = "ws.idleTimeout")) != null) {
            options.put(idleTimeoutOption, option);
        }
        if ((option = this._bayeux.getOption(maxNetworkDelayOption = "maxNetworkDelay")) != null) {
            options.put(maxNetworkDelayOption, option);
        }
        ArrayList<ClientTransport> transports = new ArrayList<ClientTransport>();
        for (ClientTransport.Factory factory : this.getClientTransportFactories()) {
            transports.add(factory.newClientTransport(cometURL, options));
        }
        ClientTransport transport = (ClientTransport)transports.get(0);
        int size = transports.size();
        ClientTransport[] otherTransports = transports.subList(1, size).toArray(new ClientTransport[0]);
        return this.newOortComet(cometURL, transport, otherTransports);
    }

    protected OortComet newOortComet(String cometURL, ClientTransport transport, ClientTransport[] otherTransports) {
        return new OortComet(this, cometURL, this.getScheduler(), transport, otherTransports);
    }

    protected void configureOortComet(OortComet oortComet) {
        boolean present;
        if (this.isAckExtensionEnabled()) {
            present = false;
            for (ClientSession.Extension extension : oortComet.getExtensions()) {
                if (!(extension instanceof AckExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                oortComet.addExtension((ClientSession.Extension)new AckExtension());
            }
        }
        if (this.isBinaryExtensionEnabled()) {
            present = false;
            for (ClientSession.Extension extension : oortComet.getExtensions()) {
                if (!(extension instanceof org.cometd.client.ext.BinaryExtension)) continue;
                present = true;
                break;
            }
            if (!present) {
                oortComet.addExtension((ClientSession.Extension)new org.cometd.client.ext.BinaryExtension());
            }
        }
    }

    protected String encodeSecret(String secret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] bytes = digest.digest(secret.getBytes(StandardCharsets.UTF_8));
            return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x);
        }
    }

    OortComet createOortComet(String cometURL) {
        return this._membership.createOortComet(cometURL);
    }

    void connectComet(OortComet comet) {
        this.connectComet(comet, this.newOortHandshakeFields(comet.getURL(), null));
    }

    protected void connectComet(OortComet comet, Map<String, Object> fields) {
        comet.handshake(fields);
    }

    public OortComet deobserveComet(String cometURL) {
        return this._membership.deobserveComet(cometURL);
    }

    @ManagedAttribute(value="URLs of known Oorts in the cluster", readonly=true)
    public Set<String> getKnownComets() {
        return this._membership.getKnownComets();
    }

    public OortComet getComet(String cometURL) {
        return this._membership.getComet(cometURL);
    }

    protected OortComet findComet(String cometURL) {
        return this._membership.findComet(cometURL);
    }

    @ManagedOperation(value="Observes the given channel", impact="ACTION")
    public void observeChannel(@Name(value="channel", description="The channel to observe") String channelName) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Observing channel {}", (Object)channelName);
        }
        if (!ChannelId.isBroadcast((String)channelName)) {
            throw new IllegalArgumentException("Channel " + channelName + " cannot be observed because is not a broadcast channel");
        }
        if (this._channels.putIfAbsent(channelName, Boolean.TRUE) == null) {
            Set<String> observedChannels = this.getObservedChannels();
            this._membership.observeChannels(observedChannels);
        }
    }

    @ManagedOperation(value="Deobserves the given channel", impact="ACTION")
    public void deobserveChannel(@Name(value="channel", description="The channel to deobserve") String channelId) {
        if (this._channels.remove(channelId) != null) {
            this._membership.deobserveChannel(channelId);
        }
    }

    public boolean isOort(ServerSession session) {
        if (session == null) {
            return false;
        }
        String id = session.getId();
        if (id.equals(this._oortSession.getId())) {
            return true;
        }
        if (this._membership.containsServerSession(session)) {
            return true;
        }
        return session.getAttribute(COMET_URL_ATTRIBUTE) != null;
    }

    public boolean isOortHandshake(Message handshake) {
        if (!"/meta/handshake".equals(handshake.getChannel())) {
            return false;
        }
        Map ext = handshake.getExt();
        if (ext == null) {
            return false;
        }
        Object oortExtObject = ext.get(EXT_OORT_FIELD);
        if (!(oortExtObject instanceof Map)) {
            return false;
        }
        Map oortExt = (Map)oortExtObject;
        String cometURL = (String)oortExt.get(EXT_COMET_URL_FIELD);
        if (!this.getURL().equals(cometURL)) {
            return false;
        }
        String b64RemoteSecret = (String)oortExt.get(EXT_OORT_SECRET_FIELD);
        String b64LocalSecret = this.encodeSecret(this.getSecret());
        return b64LocalSecret.equals(b64RemoteSecret);
    }

    protected Map<String, Object> newOortHandshakeFields(String cometURL, String oortAliasURL) {
        HashMap<String, Object> fields = new HashMap<String, Object>(1);
        HashMap ext = new HashMap(1);
        fields.put("ext", ext);
        HashMap<String, String> oortExt = new HashMap<String, String>(4);
        ext.put(EXT_OORT_FIELD, oortExt);
        oortExt.put(EXT_OORT_URL_FIELD, this.getURL());
        oortExt.put(EXT_OORT_ID_FIELD, this.getId());
        String b64Secret = this.encodeSecret(this.getSecret());
        oortExt.put(EXT_OORT_SECRET_FIELD, b64Secret);
        oortExt.put(EXT_COMET_URL_FIELD, cometURL);
        if (oortAliasURL != null) {
            oortExt.put(EXT_OORT_ALIAS_URL_FIELD, oortAliasURL);
        }
        return fields;
    }

    protected boolean isCometConnected(String oortURL) {
        return this._membership.isCometConnected(oortURL);
    }

    public void addCometListener(CometListener listener) {
        this._cometListeners.add(listener);
    }

    public void removeCometListener(CometListener listener) {
        this._cometListeners.remove(listener);
    }

    public void removeCometListeners() {
        this._cometListeners.clear();
    }

    void notifyCometJoined(String remoteOortId, String remoteOortURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Comet joined: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
        }
        CometListener.Event event = new CometListener.Event(this, remoteOortId, remoteOortURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometJoined(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + cometListener, x);
            }
        }
    }

    void notifyCometLeft(String remoteOortId, String remoteOortURL) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Comet left: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
        }
        CometListener.Event event = new CometListener.Event(this, remoteOortId, remoteOortURL);
        for (CometListener cometListener : this._cometListeners) {
            try {
                cometListener.cometLeft(event);
            }
            catch (Throwable x) {
                this._logger.info("Exception while invoking listener " + cometListener, x);
            }
        }
    }

    protected void joinComets(Message message) {
        Object[] array;
        Object data = message.getData();
        for (Object element : array = data instanceof List ? ((List)data).toArray() : (Object[])data) {
            this.observeComet((String)element);
        }
    }

    public Set<String> getObservedChannels() {
        return Set.copyOf(this._channels.keySet());
    }

    List<String> knownOortIds() {
        return this._membership.knownOortIds();
    }

    public LocalSession getOortSession() {
        return this._oortSession;
    }

    static String loggerName(Class<?> klass, String oortURL, String name) {
        String result = klass.getName() + "." + Oort.replacePunctuation(oortURL, '_');
        if (name != null) {
            result = result + "." + name;
        }
        return result;
    }

    protected static String replacePunctuation(String source, char replacement) {
        String replaced = source.replaceAll("[^\\p{Alnum}]", String.valueOf(replacement));
        return replaced.replaceAll("(" + replacement + ")\\1+", "$1");
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("observed channels", this._channels.keySet())});
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getURL());
    }

    protected class CloudListener
    implements ServerChannel.MessageListener {
        protected CloudListener() {
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (!from.isLocalSession()) {
                Oort.this.joinComets((Message)message);
            }
            return true;
        }
    }

    private class AllChannelsFilter
    implements BayeuxServer.SubscriptionListener,
    ServerSession.MessageListener {
        private AllChannelsFilter() {
        }

        public void subscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
            if ("/**".equals(channel.getId()) && !session.isLocalSession() && !Oort.this.isOort(session)) {
                session.addListener((ServerSession.ServerSessionListener)this);
            }
        }

        public boolean onMessage(ServerSession session, ServerSession sender, ServerMessage message) {
            if (message.getChannel().startsWith("/oort/")) {
                if (Oort.this._logger.isDebugEnabled()) {
                    Oort.this._logger.debug("Dropping Oort message {} to channel '/**' subscriber {}", (Object)message, (Object)session);
                }
                return false;
            }
            return true;
        }
    }

    private class OortAuthorizer
    implements Authorizer {
        private OortAuthorizer() {
        }

        public Authorizer.Result authorize(Authorizer.Operation operation, ChannelId channel, ServerSession session, ServerMessage message) {
            if (session.isLocalSession() || Oort.this.isOort(session)) {
                return Authorizer.Result.grant();
            }
            return Authorizer.Result.ignore();
        }
    }

    public static interface CometListener
    extends EventListener {
        default public void cometJoined(Event event) {
        }

        default public void cometLeft(Event event) {
        }

        public static class Event
        extends EventObject {
            private final String cometId;
            private final String cometURL;

            public Event(Oort source, String cometId, String cometURL) {
                super((Object)source);
                this.cometId = cometId;
                this.cometURL = cometURL;
            }

            public Oort getOort() {
                return (Oort)((Object)this.getSource());
            }

            public String getCometId() {
                return this.cometId;
            }

            public String getCometURL() {
                return this.cometURL;
            }
        }
    }
}

