/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.service.impl;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import io.meeds.gamification.twitter.service.TwitterTriggerService;
import io.meeds.gamification.twitter.service.impl.TwitterTriggerServiceImpl$AjcClosure1;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.picocontainer.Startable;

public class TwitterTriggerServiceImpl
implements TwitterTriggerService,
Startable {
    private static final Log LOG;
    public static final String CONNECTOR_NAME = "twitter";
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    private final ConnectorService connectorService;
    private final EventService eventService;
    private final IdentityManager identityManager;
    private final ListenerService listenerService;
    private ExecutorService executorService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TwitterTriggerServiceImpl(ListenerService listenerService, ConnectorService connectorService, IdentityManager identityManager, EventService eventService) {
        this.listenerService = listenerService;
        this.connectorService = connectorService;
        this.identityManager = identityManager;
        this.eventService = eventService;
    }

    public void start() {
        QueuedThreadPool threadFactory = new QueuedThreadPool(5, 1, 1);
        threadFactory.setName("Gamification - Twitter connector");
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public void handleTriggerAsync(TwitterTrigger twitterTrigger) {
        this.executorService.execute(() -> this.handleTriggerAsyncInternal(twitterTrigger));
    }

    @ExoTransactional
    public void handleTriggerAsyncInternal(TwitterTrigger twitterTrigger) {
        TwitterTrigger twitterTrigger2 = twitterTrigger;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)twitterTrigger2);
        Object[] objectArray = new Object[]{this, twitterTrigger2, joinPoint};
        TwitterTriggerServiceImpl$AjcClosure1 twitterTriggerServiceImpl$AjcClosure1 = new TwitterTriggerServiceImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(twitterTriggerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private boolean isEventEnabled(String eventName, String trigger, String remoteAccountId) {
        EventDTO eventDTO = this.eventService.getEventByTitleAndTrigger(eventName, trigger);
        return eventDTO != null && this.isAccountEventEnabled(eventDTO, remoteAccountId);
    }

    private boolean isAccountEventEnabled(EventDTO eventDTO, String remoteAccountId) {
        String accountPropertyKey = remoteAccountId + ".enabled";
        Map properties = eventDTO.getProperties();
        if (properties != null && !properties.isEmpty()) {
            return Boolean.parseBoolean((String)properties.get(accountPropertyKey));
        }
        return true;
    }

    private void processEvent(TwitterTrigger twitterTrigger) {
        Identity socialIdentity;
        if (!this.isEventEnabled(twitterTrigger.getTrigger(), twitterTrigger.getTrigger(), String.valueOf(twitterTrigger.getAccountId()))) {
            return;
        }
        String receiverId = this.connectorService.getAssociatedUsername(CONNECTOR_NAME, twitterTrigger.getTwitterUsername());
        if (StringUtils.isNotBlank((CharSequence)receiverId) && (socialIdentity = this.identityManager.getOrCreateUserIdentity(receiverId)) != null) {
            this.broadcastTwitterEvent(twitterTrigger.getTrigger(), receiverId, String.valueOf(twitterTrigger.getTweetId()), twitterTrigger.getType());
        }
    }

    private void broadcastTwitterEvent(String ruleTitle, String receiverId, String objectId, String objectType) {
        try {
            EventDTO eventDTO = this.eventService.getEventByTypeAndTitle(CONNECTOR_NAME, ruleTitle);
            if (eventDTO != null) {
                HashMap<String, String> gam = new HashMap<String, String>();
                gam.put("senderId", receiverId);
                gam.put("receiverId", receiverId);
                gam.put("objectId", objectId);
                gam.put("objectType", objectType);
                gam.put("ruleTitle", eventDTO.getTitle());
                this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gam, (Object)"");
                LOG.info("Twitter action {} broadcasted for user {}", new Object[]{ruleTitle, receiverId});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast twitter gamification event", (Throwable)e);
        }
    }

    static {
        TwitterTriggerServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(TwitterTriggerServiceImpl.class);
    }

    static /* synthetic */ void handleTriggerAsyncInternal_aroundBody0(TwitterTriggerServiceImpl ajc$this, TwitterTrigger twitterTrigger, JoinPoint joinPoint) {
        ajc$this.processEvent(twitterTrigger);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TwitterTriggerServiceImpl.java", TwitterTriggerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleTriggerAsyncInternal", "io.meeds.gamification.twitter.service.impl.TwitterTriggerServiceImpl", "io.meeds.gamification.twitter.model.TwitterTrigger", "twitterTrigger", "", "void"), 91);
    }
}

