/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAllItemsPreferenceForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_SHOW_OWNED_BY_USER_DOC = "showOwnedByUser";
    public static final String FIELD_SHOW_FAVOURITES = "showFavourites";
    public static final String FIELD_SHOW_HIDDENS = "showHiddens";

    public UIAllItemsPreferenceForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOW_OWNED_BY_USER_DOC, FIELD_SHOW_OWNED_BY_USER_DOC, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOW_FAVOURITES, FIELD_SHOW_FAVOURITES, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_SHOW_HIDDENS, FIELD_SHOW_HIDDENS, null));
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void update(Preference pref) {
        this.getUICheckBoxInput(FIELD_SHOW_OWNED_BY_USER_DOC).setChecked(pref.isShowOwnedByUserDoc());
        this.getUICheckBoxInput(FIELD_SHOW_FAVOURITES).setChecked(pref.isShowFavouriteDoc());
        this.getUICheckBoxInput(FIELD_SHOW_HIDDENS).setChecked(pref.isShowHiddenDoc());
    }

    public static class CancelActionListener
    extends EventListener<UIAllItemsPreferenceForm> {
        public void execute(Event<UIAllItemsPreferenceForm> event) throws Exception {
            UIAllItemsPreferenceForm uiForm = (UIAllItemsPreferenceForm)((Object)event.getSource());
            UIJCRExplorerPortlet uiExplorerPortlet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiExplorerPortlet.findFirstComponentOfType(UIJCRExplorer.class);
            ((UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class)).cancelPopupAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIAllItemsPreferenceForm> {
        public void execute(Event<UIAllItemsPreferenceForm> event) throws Exception {
            UIAllItemsPreferenceForm uiForm = (UIAllItemsPreferenceForm)((Object)event.getSource());
            UIJCRExplorerPortlet uiExplorerPortlet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiExplorerPortlet.findFirstComponentOfType(UIJCRExplorer.class);
            Preference pref = uiExplorer.getPreference();
            pref.setShowOwnedByUserDoc(uiForm.getUICheckBoxInput(UIAllItemsPreferenceForm.FIELD_SHOW_OWNED_BY_USER_DOC).isChecked());
            pref.setShowFavouriteDoc(uiForm.getUICheckBoxInput(UIAllItemsPreferenceForm.FIELD_SHOW_FAVOURITES).isChecked());
            pref.setShowHiddenDoc(uiForm.getUICheckBoxInput(UIAllItemsPreferenceForm.FIELD_SHOW_HIDDENS).isChecked());
            uiExplorer.refreshExplorer();
            uiExplorerPortlet.setRenderedChild(UIJCRExplorer.class);
        }
    }
}

