/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.cms.service.CMSService;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.webui.Utils;

public class CMSPortlet
extends GenericDispatchedViewPortlet {
    protected static final Random RANDOM = new Random();
    protected static final String NAME = "name";
    private static final String PREFIX_UNTITLED_NAME = "Untitled";
    private static final Map<String, Boolean> INITIALIZED = new ConcurrentHashMap<String, Boolean>();
    private static final Log LOG = ExoLogger.getLogger(CMSPortlet.class);
    protected String contentType;
    private CMSService cmsService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.contentType = config.getInitParameter("content-type");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String name = this.getOrCreateSettingName(request.getPreferences());
        request.setAttribute("canEdit", (Object)this.canEdit(name, this.getCurrentAclIdentity()));
        request.setAttribute("settingName", (Object)name);
        this.setViewRequestAttributes(name, request, response);
        super.doView(request, response);
    }

    protected void saveSettingName(String name, String pageReference, long spaceId) {
        String identityId = Utils.getViewerIdentityId();
        try {
            this.getCmsService().saveSettingName(this.contentType, name, pageReference, spaceId, identityId == null ? 0L : Long.parseLong(identityId));
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.debug("CMS Setting {}/{} already exists", new Object[]{this.contentType, name, e});
        }
        INITIALIZED.remove(name);
    }

    protected boolean isSettingNameExists(String name) {
        return this.getCmsService().isSettingNameExists(this.contentType, name);
    }

    protected boolean canEdit(String name, Identity userAclIdentity) {
        return this.getCmsService().hasEditPermission(this.getCurrentAclIdentity(), this.contentType, name);
    }

    protected void setViewRequestAttributes(String name, RenderRequest request, RenderResponse response) {
    }

    protected void preSettingInit(PortletPreferences preferences, String name) {
    }

    protected void postSettingInit(PortletPreferences preferences, String name) {
    }

    protected void savePreference(String name, String value) {
        String storageId = UIPortlet.getCurrentUIPortlet().getStorageId();
        LayoutService layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
        Application applicationModel = layoutService.getApplicationModel(storageId);
        ApplicationState state = applicationModel.getState();
        Portlet prefs = (Portlet)layoutService.load(state, ApplicationType.PORTLET);
        prefs.setValue(name, value);
        layoutService.save(state, (Object)prefs);
    }

    private String getOrCreateSettingName(PortletPreferences preferences) {
        String name = preferences.getValue(NAME, null);
        if (!this.isInitialized(name)) {
            if (name == null) {
                name = this.generateRandomId();
                this.savePreference(NAME, name);
            }
            this.preSettingInit(preferences, name);
            this.saveSettingName(name, this.getCurrentPageReference(), this.getCurrentSpaceId());
            this.postSettingInit(preferences, name);
        }
        return name;
    }

    private boolean isInitialized(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        return INITIALIZED.computeIfAbsent(name, this::isSettingNameExists);
    }

    private String generateRandomId() {
        String name;
        while (this.isSettingNameExists(name = PREFIX_UNTITLED_NAME + String.valueOf(RANDOM.nextLong()))) {
        }
        return name;
    }

    private CMSService getCmsService() {
        if (this.cmsService == null) {
            this.cmsService = (CMSService)ExoContainerContext.getService(CMSService.class);
        }
        return this.cmsService;
    }

    private Identity getCurrentAclIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null ? null : conversationState.getIdentity();
    }

    private String getCurrentPageReference() {
        return Util.getUIPage().getPageId();
    }

    private long getCurrentSpaceId() {
        String spaceId = Utils.getSpaceIdByContext();
        return spaceId == null ? 0L : Long.parseLong(spaceId);
    }
}

