/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import org.exoplatform.ecm.webui.component.admin.script.UIScriptContainer;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfig(template="app:/groovy/webui/component/admin/script/UIScriptManager.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})
public class UIScriptManager
extends UIAbstractManager {
    private String selectedTabId = "UIScriptContainer";
    public static final String POPUP_TEMPLATE_ID = "ScriptContainerPopup";
    public static final String ACTION_TEMPLATE_ID = "UIActionScriptContainer";
    public static final String INTERCEPTOR_TEMPLATE_ID = "UIInterceptorScriptContainer";
    public static final String WIDGET_TEMPLATE_ID = "UIWidgetScriptContainer";
    public static final String ACTION_TEMPLATE_LIST_ID = "UIActionTemplateList";
    public static final String INTERCEPTOR_TEMPLATE_LIST_ID = "UIInterceptorTemplateList";
    public static final String WIDGET_TEMPLATE_LIST_ID = "UIWidgetTemplateList";

    public String getSelectedTabId() {
        return this.selectedTabId;
    }

    public void setSelectedTab(String renderTabId) {
        this.selectedTabId = renderTabId;
    }

    public void setSelectedTab(int index) {
        this.selectedTabId = this.getChild(index - 1).getId();
    }

    public UIScriptManager() throws Exception {
        UIScriptContainer uiActionTemp = (UIScriptContainer)this.addChild(UIScriptContainer.class, null, ACTION_TEMPLATE_ID);
        ((UIScriptList)uiActionTemp.getChild(UIScriptList.class)).setTemplateFilter("action");
        UIScriptContainer uiInterceptorTemp = (UIScriptContainer)this.addChild(UIScriptContainer.class, null, INTERCEPTOR_TEMPLATE_ID);
        ((UIScriptList)uiInterceptorTemp.getChild(UIScriptList.class)).setTemplateFilter("interceptor");
        UIScriptContainer uiWidgetTemp = (UIScriptContainer)this.addChild(UIScriptContainer.class, null, WIDGET_TEMPLATE_ID);
        ((UIScriptList)uiWidgetTemp.getChild(UIScriptList.class)).setTemplateFilter("widget");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, POPUP_TEMPLATE_ID);
        this.setSelectedTab(ACTION_TEMPLATE_ID);
    }

    public void initPopup(UIComponent uiComponent) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(POPUP_TEMPLATE_ID);
        uiPopup.setRendered(true);
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(600, 270);
        uiPopup.setUIComponent(uiComponent);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void refresh() throws Exception {
        UIScriptContainer actionContainer = (UIScriptContainer)this.getChildById(ACTION_TEMPLATE_ID);
        actionContainer.update();
        ((UIScriptList)actionContainer.getChild(UIScriptList.class)).refresh("action", 1);
        UIScriptContainer interceptorContainer = (UIScriptContainer)this.getChildById(INTERCEPTOR_TEMPLATE_ID);
        interceptorContainer.update();
        ((UIScriptList)interceptorContainer.getChild(UIScriptList.class)).refresh("interceptor", 1);
        UIScriptContainer widgetContainer = (UIScriptContainer)this.getChildById(WIDGET_TEMPLATE_ID);
        widgetContainer.update();
        ((UIScriptList)widgetContainer.getChild(UIScriptList.class)).refresh("widget", 1);
    }

    public static class SelectTabActionListener
    extends EventListener<UIScriptManager> {
        public void execute(Event<UIScriptManager> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            ((UIScriptManager)((Object)event.getSource())).setSelectedTab(renderTab);
            WebuiRequestContext parentContext = (WebuiRequestContext)context.getParentAppRequestContext();
            if (parentContext != null) {
                parentContext.setResponseComplete(true);
            } else {
                context.setResponseComplete(true);
            }
        }
    }
}

