/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.codec;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.gatein.common.util.Base64;

public class JCASymmetricCodec
extends AbstractCodec {
    private final Cipher encrypter;
    private final Cipher decrypter;

    JCASymmetricCodec(String transformation, SecretKey key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        this.encrypter = Cipher.getInstance(transformation);
        this.decrypter = Cipher.getInstance(transformation);
        this.encrypter.init(1, key);
        this.decrypter.init(2, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encode(String plainInput) {
        try {
            byte[] bytes;
            Cipher cipher = this.encrypter;
            synchronized (cipher) {
                bytes = this.encrypter.doFinal(plainInput.getBytes());
            }
            return Base64.encodeBytes((byte[])bytes);
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decode(String encodedInput) {
        try {
            byte[] bytes = Base64.decode((String)encodedInput);
            Cipher cipher = this.decrypter;
            synchronized (cipher) {
                bytes = this.decrypter.doFinal(bytes);
            }
            return new String(bytes);
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

