/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.metadata.thumbnail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.metadata.thumbnail.ImageThumbnailService;
import org.exoplatform.social.metadata.thumbnail.model.ThumbnailObject;

public class ImageThumbnailServiceImpl
implements ImageThumbnailService {
    private static final Log LOG = ExoLogger.getExoLogger(ImageThumbnailServiceImpl.class);
    private static final MetadataType THUMBNAIL_METADATA_TYPE = new MetadataType(5L, "thumbnail");
    private static final String SOCIAL_NAME_SPACE = "social";
    private static final String THUMBNAIL_OBJECT_TYPE = "file";
    private static final String THUMBNAIL_WIDTH_PROPERTY = "width";
    private static final String THUMBNAIL_HEIGHT_PROPERTY = "height";
    private final MetadataService metadataService;
    private final FileService fileService;
    private final ImageResizeService imageResizeService;

    public ImageThumbnailServiceImpl(MetadataService metadataService, FileService fileService, ImageResizeService imageResizeService) {
        this.metadataService = metadataService;
        this.fileService = fileService;
        this.imageResizeService = imageResizeService;
    }

    public FileItem getOrCreateThumbnail(FileItem file, Identity identity, int width, int height) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("file argument is mandatory");
        }
        if (width == 0 && height == 0) {
            return file;
        }
        FileInfo fileInfo = file.getFileInfo();
        ThumbnailObject thumbnailObject = new ThumbnailObject(THUMBNAIL_OBJECT_TYPE, Long.toString(fileInfo.getId()));
        List metadataItemList = this.metadataService.getMetadataItemsByMetadataTypeAndObject(THUMBNAIL_METADATA_TYPE.getName(), (MetadataObject)thumbnailObject);
        List<MetadataItem> items = metadataItemList.stream().filter(metadataItem -> metadataItem.getProperties() != null && ((String)metadataItem.getProperties().get(THUMBNAIL_WIDTH_PROPERTY)).equals(String.valueOf(width)) && ((String)metadataItem.getProperties().get(THUMBNAIL_HEIGHT_PROPERTY)).equals(String.valueOf(height))).toList();
        if (!items.isEmpty()) {
            long fileId = Long.parseLong(items.get(0).getParentObjectId());
            try {
                return this.fileService.getFile(fileId);
            }
            catch (FileStorageException e) {
                LOG.warn("Error while getting thumbnail for image of identity {}, original Image will be returned", new Object[]{identity.getId(), e.getMessage()});
                return file;
            }
        }
        byte[] imageContent = this.imageResizeService.scaleImage(IOUtils.toByteArray((InputStream)file.getAsStream()), width, height, false, false);
        FileItem thumbnail = new FileItem(null, fileInfo.getName(), fileInfo.getMimetype(), SOCIAL_NAME_SPACE, (long)imageContent.length, new Date(), fileInfo.getUpdater(), false, (InputStream)new ByteArrayInputStream(imageContent));
        FileItem thumbnailFileItem = this.fileService.writeFile(thumbnail);
        FileInfo thumbnailFileInfo = thumbnailFileItem.getFileInfo();
        ThumbnailObject thumbnailMetadataObject = new ThumbnailObject(THUMBNAIL_OBJECT_TYPE, Long.toString(fileInfo.getId()), Long.toString(thumbnailFileInfo.getId()));
        MetadataKey metadataKey = new MetadataKey(THUMBNAIL_METADATA_TYPE.getName(), THUMBNAIL_METADATA_TYPE.getName(), 0L);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(THUMBNAIL_WIDTH_PROPERTY, String.valueOf(width));
        properties.put(THUMBNAIL_HEIGHT_PROPERTY, String.valueOf(height));
        this.metadataService.createMetadataItem((MetadataObject)thumbnailMetadataObject, metadataKey, properties, Long.parseLong(identity.getId()));
        return thumbnailFileItem;
    }

    public void deleteThumbnails(Long fileId) {
        ThumbnailObject thumbnailObject = new ThumbnailObject(THUMBNAIL_OBJECT_TYPE, Long.toString(fileId));
        this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(THUMBNAIL_METADATA_TYPE.getName(), (MetadataObject)thumbnailObject);
    }
}

