/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;

public abstract class AbstractNamespaceMappings
implements NamespaceMappings {
    private final LocationFactory resolver = new LocationFactory(this);

    @Override
    public String translateName(InternalQName qName) throws IllegalNameException {
        try {
            return this.resolver.createJCRName(qName).getAsString();
        }
        catch (RepositoryException e) {
            throw new IllegalNameException("Internal error.", e);
        }
    }

    @Override
    public String translatePath(QPath path) throws IllegalNameException {
        try {
            return this.resolver.createJCRPath(path).getAsString(false);
        }
        catch (RepositoryException e) {
            throw new IllegalNameException("Internal error.", e);
        }
    }
}

