/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.config.model.LocalizedValue;

public class I18NValue<V, L extends LocalizedValue<V>>
extends ArrayList<L> {
    public static I18NValue create() {
        return new I18NValue();
    }

    public I18NValue() {
    }

    public I18NValue(Collection<? extends L> c) {
        super(c);
    }

    public I18NValue(L ... c) {
        super(Arrays.asList(c));
    }

    public boolean isSimple() {
        return this.size() == 1 && ((LocalizedValue)this.get(0)).getLang() == null;
    }

    public boolean isExtended() {
        return !this.isEmpty() && !this.isSimple();
    }

    public V getSimple() {
        if (this.isSimple()) {
            return ((LocalizedValue)this.get(0)).getValue();
        }
        return null;
    }

    public Map<Locale, V> getExtended(Locale defaultLocale) {
        Map map = Collections.emptyMap();
        LocalizedValue unqualifiedLocalizedValue = null;
        for (LocalizedValue localizedValue : this) {
            if (localizedValue.getLang() != null) {
                if (map.isEmpty()) {
                    map = new HashMap();
                }
                map.put(localizedValue.getLang(), localizedValue.getValue());
                continue;
            }
            unqualifiedLocalizedValue = localizedValue;
        }
        if (map.isEmpty()) {
            return null;
        }
        if (unqualifiedLocalizedValue != null && !map.containsKey(defaultLocale)) {
            map.put(defaultLocale, unqualifiedLocalizedValue.getValue());
        }
        return map;
    }
}

