/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import java.util.List;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.service.WalletTransactionService;

public class WalletDeletedListener
extends Listener<Wallet, String> {
    private WalletTransactionService transactionService;

    public WalletDeletedListener(WalletTransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void onEvent(Event<Wallet, String> event) throws Exception {
        Wallet wallet = (Wallet)event.getSource();
        List pendingTransactions = this.transactionService.getPendingWalletTransactionsNotSent(wallet.getAddress());
        if (pendingTransactions != null) {
            pendingTransactions.forEach(transactionDetail -> {
                transactionDetail.setPending(false);
                this.transactionService.saveTransactionDetail(transactionDetail, true);
            });
        }
    }
}

