/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CompressedISPNChangesBuffer;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.ISPNCacheWorkspaceStorageCache;
import org.exoplatform.services.jcr.infinispan.CacheKey;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.filter.KeyFilter;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;

public class BufferedISPNCache
implements Cache<CacheKey, Object> {
    private final AdvancedCache<CacheKey, Object> parentCache;
    private final ThreadLocal<CompressedISPNChangesBuffer> changesList = new ThreadLocal();
    private ThreadLocal<Boolean> local = new ThreadLocal();
    private final Boolean allowLocalChanges;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.BufferedISPNCache");

    public void addListener(Object listener, KeyFilter<? super CacheKey> filter) {
        this.parentCache.addListener(listener, filter);
    }

    public <C> void addListener(Object listener, CacheEventFilter<? super CacheKey, ? super Object> filter, CacheEventConverter<? super CacheKey, ? super Object, C> converter) {
        this.parentCache.addListener(listener, filter, converter);
    }

    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super CacheKey, ? super Object> filter, CacheEventConverter<? super CacheKey, ? super Object, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.parentCache.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    public NotifyingFuture<Object> putAsync(CacheKey key, Object value) {
        return this.parentCache.putAsync((Object)key, value);
    }

    public NotifyingFuture<Object> putAsync(CacheKey key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.putAsync((Object)key, value, lifespan, unit);
    }

    public NotifyingFuture<Object> putAsync(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.putAsync((Object)key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends CacheKey, ?> data) {
        return this.parentCache.putAllAsync(data);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends CacheKey, ?> data, long lifespan, TimeUnit unit) {
        return this.parentCache.putAllAsync(data, lifespan, unit);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends CacheKey, ?> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Void> clearAsync() {
        return this.parentCache.clearAsync();
    }

    public NotifyingFuture<Object> putIfAbsentAsync(CacheKey key, Object value) {
        return this.parentCache.putIfAbsentAsync((Object)key, value);
    }

    public NotifyingFuture<Object> putIfAbsentAsync(CacheKey key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.putIfAbsentAsync((Object)key, value, lifespan, unit);
    }

    public NotifyingFuture<Object> putIfAbsentAsync(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.putIfAbsentAsync((Object)key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Object> removeAsync(Object key) {
        return this.parentCache.removeAsync(key);
    }

    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.parentCache.removeAsync(key, value);
    }

    public NotifyingFuture<Object> replaceAsync(CacheKey key, Object value) {
        return this.parentCache.replaceAsync((Object)key, value);
    }

    public NotifyingFuture<Object> replaceAsync(CacheKey key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.replaceAsync((Object)key, value, lifespan, unit);
    }

    public NotifyingFuture<Object> replaceAsync(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.replaceAsync((Object)key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Boolean> replaceAsync(CacheKey key, Object oldValue, Object newValue) {
        return this.parentCache.replaceAsync((Object)key, oldValue, newValue);
    }

    public NotifyingFuture<Boolean> replaceAsync(CacheKey key, Object oldValue, Object newValue, long lifespan, TimeUnit unit) {
        return this.parentCache.replaceAsync((Object)key, oldValue, newValue, lifespan, unit);
    }

    public NotifyingFuture<Boolean> replaceAsync(CacheKey key, Object oldValue, Object newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.parentCache.replaceAsync((Object)key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public NotifyingFuture<Object> getAsync(CacheKey key) {
        return null;
    }

    public BufferedISPNCache(Cache<CacheKey, Object> parentCache, Boolean allowLocalChanges) {
        this.parentCache = parentCache.getAdvancedCache();
        this.allowLocalChanges = allowLocalChanges;
    }

    public void endBatch(boolean successful) {
        this.parentCache.endBatch(successful);
    }

    public void evict(CacheKey key) {
        this.parentCache.evict((Object)key);
    }

    public AdvancedCache<CacheKey, Object> getAdvancedCache() {
        return this.parentCache.getAdvancedCache();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.parentCache.getCacheManager();
    }

    public String getName() {
        return this.parentCache.getName();
    }

    public ComponentStatus getStatus() {
        return this.parentCache.getStatus();
    }

    public String getVersion() {
        return this.parentCache.getVersion();
    }

    public Object put(CacheKey key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.put((Object)key, value, lifespan, unit);
    }

    public Object put(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.put((Object)key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void putAll(Map<? extends CacheKey, ? extends Object> map, long lifespan, TimeUnit unit) {
        this.parentCache.putAll(map, lifespan, unit);
    }

    public void putAll(Map<? extends CacheKey, ? extends Object> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.parentCache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void putForExternalRead(CacheKey key, Object value) {
        this.parentCache.putForExternalRead((Object)key, value);
    }

    public void putForExternalRead(CacheKey key, Object value, long lifespan, TimeUnit unit) {
    }

    public void putForExternalRead(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
    }

    public Object putIfAbsent(CacheKey key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.putIfAbsent((Object)key, value, lifespan, unit);
    }

    public Object putIfAbsent(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.putIfAbsent((Object)key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public Object replace(CacheKey key, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.replace((Object)key, value, lifespan, unit);
    }

    public boolean replace(CacheKey key, Object oldValue, Object value, long lifespan, TimeUnit unit) {
        return this.parentCache.replace((Object)key, oldValue, value, lifespan, unit);
    }

    public Object replace(CacheKey key, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.replace((Object)key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public boolean replace(CacheKey key, Object oldValue, Object value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.parentCache.replace((Object)key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public boolean startBatch() {
        return this.parentCache.startBatch();
    }

    public Object putIfAbsent(CacheKey key, Object value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectIfAbsentContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
        return null;
    }

    public Object putIfAbsent(CacheKey key, Object value, long lifespan) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectIfAbsentContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.allowLocalChanges, lifespan));
        return null;
    }

    public boolean remove(Object key, Object value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveIfExistKeyContainer((CacheKey)key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
        return false;
    }

    public Object replace(CacheKey key, Object value) {
        return this.parentCache.replace((Object)key, value);
    }

    public boolean replace(CacheKey key, Object oldValue, Object newValue) {
        return this.parentCache.replace((Object)key, oldValue, newValue);
    }

    public void clear() {
        this.parentCache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
    }

    public boolean containsKey(Object key) {
        return this.parentCache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.parentCache.containsValue(value);
    }

    public Object get(Object key) {
        return this.parentCache.get(key);
    }

    public boolean isEmpty() {
        return this.parentCache.isEmpty();
    }

    public Object put(CacheKey key, Object value) {
        return this.put(key, value, false);
    }

    public Configuration getCacheConfiguration() {
        return this.parentCache.getCacheConfiguration();
    }

    public Object put(CacheKey key, Object value, boolean withReturnValue) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
        return withReturnValue ? this.parentCache.get((Object)key) : null;
    }

    public Object put(CacheKey key, Object value, boolean withReturnValue, long lifespan) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.allowLocalChanges, lifespan));
        return withReturnValue ? this.parentCache.get((Object)key) : null;
    }

    public void putAll(Map<? extends CacheKey, ? extends Object> m) {
        this.parentCache.putAll(m);
    }

    public Object remove(Object key) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveObjectContainer((CacheKey)key, this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.allowLocalChanges));
        return null;
    }

    public int size() {
        return this.parentCache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).size();
    }

    public CacheSet<CacheKey> keySet() {
        return this.parentCache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).keySet();
    }

    public CacheCollection<Object> values() {
        return this.parentCache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).values();
    }

    public CacheSet<Map.Entry<CacheKey, Object>> entrySet() {
        return this.parentCache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).entrySet();
    }

    public void start() {
        PrivilegedISPNCacheHelper.start(this.parentCache);
    }

    public void stop() {
        PrivilegedISPNCacheHelper.stop(this.parentCache);
        ISPNCacheFactory.releaseUniqueInstance(this.parentCache.getCacheManager());
    }

    public void addListener(Object listener) {
        this.parentCache.addListener(listener);
    }

    public Set<Object> getListeners() {
        return this.parentCache.getListeners();
    }

    public void removeListener(Object listener) {
        this.parentCache.removeListener(listener);
    }

    public void beginTransaction() {
        this.changesList.set(new CompressedISPNChangesBuffer());
        this.local.set(false);
    }

    public boolean isTransactionActive() {
        return this.changesList.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        TransactionManager tm = this.getTransactionManager();
        try {
            List<ChangesContainer> containers = changesContainer.getSortedList();
            this.commitChanges(tm, containers);
        }
        finally {
            this.changesList.set(null);
            changesContainer = null;
        }
    }

    private void commitChanges(TransactionManager tm, List<ChangesContainer> containers) {
        for (ChangesContainer cacheChange : containers) {
            boolean isTxCreated = false;
            try {
                if (cacheChange.isTxRequired() && tm != null && tm.getStatus() == 6) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"No Tx is active we then create a new tx");
                    }
                    tm.begin();
                    isTxCreated = true;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not create a new tx", (Throwable)e);
            }
            try {
                cacheChange.apply();
            }
            catch (RuntimeException e) {
                if (isTxCreated) {
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"An error occurs the tx will be rollbacked");
                        }
                        tm.rollback();
                    }
                    catch (Exception e1) {
                        LOG.warn((Object)"Could not rollback the tx", (Throwable)e1);
                    }
                }
                throw e;
            }
            if (!isTxCreated) continue;
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"The tx will be committed");
                }
                tm.commit();
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not commit the tx", (Throwable)e);
            }
        }
    }

    public void rollbackTransaction() {
        this.changesList.set(null);
    }

    public void setLocal(boolean local) {
        if (local && this.changesList.get() == null) {
            this.beginTransaction();
        }
        this.local.set(local);
    }

    private CompressedISPNChangesBuffer getChangesBufferSafe() {
        CompressedISPNChangesBuffer changesContainer = this.changesList.get();
        if (changesContainer == null) {
            throw new IllegalStateException("changesContainer should not be empty");
        }
        return changesContainer;
    }

    public TransactionManager getTransactionManager() {
        return this.parentCache.getTransactionManager();
    }

    public void addToList(CacheKey key, Object value, boolean forceModify) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new AddToListContainer(key, value, this.parentCache, forceModify, changesContainer.getHistoryIndex(), this.local.get(), this.allowLocalChanges));
    }

    public Object putInBuffer(CacheKey key, Object value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object prevObject = this.getObjectFromChangesContainer(changesContainer, key);
        changesContainer.add(new PutObjectContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
        if (prevObject != null) {
            return prevObject;
        }
        return this.parentCache.get((Object)key);
    }

    private Object getObjectFromChangesContainer(CompressedISPNChangesBuffer changesContainer, CacheKey key) {
        return changesContainer.get(key);
    }

    public void removeFromList(CacheKey key, Object value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveFromListContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
    }

    public void removeFromPatternList(CacheKey key, ItemData value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveFromPatternListContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
    }

    public void addToPatternList(CacheKey key, ItemData value) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new AddToPatternListContainer(key, value, this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.allowLocalChanges));
    }

    public Object getFromBuffer(CacheKey key) {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object objectFromBuffer = this.getObjectFromChangesContainer(changesContainer, key);
        if (objectFromBuffer != null) {
            return objectFromBuffer;
        }
        return this.parentCache.get((Object)key);
    }

    Map<CacheKey, Object> getLastChanges() {
        CompressedISPNChangesBuffer changesContainer = this.getChangesBufferSafe();
        return changesContainer.getLastChanges();
    }

    public static class PutObjectIfAbsentContainer
    extends ChangesContainer {
        private final Object value;
        private final long lifespan;

        public PutObjectIfAbsentContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges, long lifespan) {
            super(key, ChangesType.PUT, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
            this.lifespan = lifespan;
        }

        public PutObjectIfAbsentContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            this(key, value, cache, historicalIndex, local, allowLocalChanges, -1L);
        }

        @Override
        public void apply() {
            Object oldValue;
            if (!this.localMode && this.value instanceof ISPNCacheWorkspaceStorageCache.FakeValueSet) {
                return;
            }
            Object object = oldValue = this.lifespan == -1L ? this.setCacheLocalMode(new Flag[0]).putIfAbsent((Object)this.key, this.value) : this.setCacheLocalMode(new Flag[0]).putIfAbsent((Object)this.key, this.value, this.lifespan, TimeUnit.SECONDS);
            if (oldValue instanceof ISPNCacheWorkspaceStorageCache.FakeValueSet) {
                if (this.lifespan == -1L) {
                    this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, this.value);
                } else {
                    this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, this.value, this.lifespan, TimeUnit.SECONDS);
                }
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    public static abstract class ChangesContainer
    implements Comparable<ChangesContainer> {
        protected final CacheKey key;
        protected final ChangesType changesType;
        protected final AdvancedCache<CacheKey, Object> cache;
        protected final int historicalIndex;
        protected final boolean localMode;
        private final Boolean allowLocalChanges;

        public ChangesContainer(CacheKey key, ChangesType changesType, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean localMode, Boolean allowLocalChanges) {
            this.key = key;
            this.changesType = changesType;
            this.cache = cache;
            this.historicalIndex = historicalIndex;
            this.localMode = localMode;
            this.allowLocalChanges = allowLocalChanges;
        }

        public CacheKey getKey() {
            return this.key;
        }

        public int getHistoricalIndex() {
            return this.historicalIndex;
        }

        public ChangesType getChangesType() {
            return this.changesType;
        }

        public String toString() {
            return this.key.toString() + " type=" + this.changesType + " historysIndex=" + this.historicalIndex;
        }

        @Override
        public int compareTo(ChangesContainer o) {
            int result = this.key.compareTo(o.getKey());
            return result == 0 ? this.historicalIndex - o.getHistoricalIndex() : result;
        }

        protected AdvancedCache<CacheKey, Object> setCacheLocalMode(Flag ... flags) {
            if (this.localMode && this.allowLocalChanges.booleanValue()) {
                if (flags == null || flags.length == 0) {
                    return this.cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
                }
                Flag[] newFlags = new Flag[flags.length + 1];
                System.arraycopy(flags, 0, newFlags, 0, flags.length);
                newFlags[flags.length] = Flag.CACHE_MODE_LOCAL;
                return this.cache.withFlags(newFlags);
            }
            return flags == null || flags.length == 0 ? this.cache : this.cache.withFlags(flags);
        }

        public abstract void apply();

        public boolean isTxRequired() {
            return false;
        }

        void applyToBuffer(CompressedISPNChangesBuffer buffer) {
        }
    }

    public static class RemoveIfExistKeyContainer
    extends ChangesContainer {
        private final Object value;

        public RemoveIfExistKeyContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.REMOVE, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
        }

        @Override
        public void apply() {
            this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP).remove((Object)this.key, this.value);
        }

        @Override
        void applyToBuffer(CompressedISPNChangesBuffer buffer) {
            buffer.put(this.key, null);
        }
    }

    public static class PutObjectContainer
    extends ChangesContainer {
        private final Object value;
        private final long lifespan;

        public PutObjectContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges, long lifespan) {
            super(key, ChangesType.PUT, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
            this.lifespan = lifespan;
        }

        public PutObjectContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            this(key, value, cache, historicalIndex, local, allowLocalChanges, -1L);
        }

        @Override
        public void apply() {
            if (this.lifespan == -1L) {
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, this.value);
            } else {
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, this.value, this.lifespan, TimeUnit.SECONDS);
            }
        }

        @Override
        void applyToBuffer(CompressedISPNChangesBuffer buffer) {
            buffer.put(this.key, this.value);
        }
    }

    public static class RemoveObjectContainer
    extends ChangesContainer {
        public RemoveObjectContainer(CacheKey key, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.REMOVE, cache, historicalIndex, local, allowLocalChanges);
        }

        @Override
        public void apply() {
            this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).remove((Object)this.key);
        }

        @Override
        void applyToBuffer(CompressedISPNChangesBuffer buffer) {
            buffer.put(this.key, null);
        }
    }

    public static class AddToListContainer
    extends ChangesContainer {
        private final Object value;
        private final boolean forceModify;

        public AddToListContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, boolean forceModify, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.PUT, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
            this.forceModify = forceModify;
        }

        @Override
        public void apply() {
            if (!this.localMode && this.cache.getRpcManager() != null && this.cache.getCacheManager().getMembers().size() > 1) {
                this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES}).remove((Object)this.key);
                return;
            }
            Object existingObject = this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)this.key);
            HashSet<Object> newSet = new HashSet<Object>();
            if (existingObject instanceof Set || existingObject == null && this.forceModify) {
                if (existingObject instanceof ISPNCacheWorkspaceStorageCache.FakeValueSet) {
                    this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).remove((Object)this.key);
                    return;
                }
                if (existingObject instanceof Set) {
                    newSet.addAll((Set)existingObject);
                }
                newSet.add(this.value);
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, newSet);
            } else if (existingObject != null) {
                LOG.error((Object)("Unexpected object found by key " + this.key.toString() + ". Expected Set, but found:" + existingObject.getClass().getName()));
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    public static class RemoveFromListContainer
    extends ChangesContainer {
        private final Object value;

        public RemoveFromListContainer(CacheKey key, Object value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.REMOVE, cache, historicalIndex, local, allowLocalChanges);
            this.value = value;
        }

        @Override
        public void apply() {
            if (!this.localMode && this.cache.getRpcManager() != null && this.cache.getCacheManager().getMembers().size() > 1) {
                this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES}).remove((Object)this.key);
                return;
            }
            Object existingObject = this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)this.key);
            if (existingObject instanceof ISPNCacheWorkspaceStorageCache.FakeValueSet) {
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).remove((Object)this.key);
                return;
            }
            if (existingObject instanceof Set) {
                HashSet newSet = new HashSet((Set)existingObject);
                newSet.remove(this.value);
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, newSet);
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    public static class RemoveFromPatternListContainer
    extends ChangesContainer {
        private final ItemData itemData;

        public RemoveFromPatternListContainer(CacheKey key, ItemData value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.REMOVE, cache, historicalIndex, local, allowLocalChanges);
            this.itemData = value;
        }

        @Override
        public void apply() {
            if (!this.localMode && this.cache.getRpcManager() != null && this.cache.getCacheManager().getMembers().size() > 1) {
                this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES}).remove((Object)this.key);
                return;
            }
            Object existingObject = this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)this.key);
            if (existingObject instanceof Map) {
                HashMap newMap = new HashMap((HashMap)existingObject);
                for (QPathEntryFilter pattern : newMap.keySet()) {
                    if (!pattern.accept(this.itemData)) continue;
                    HashSet newSet = new HashSet((Collection)newMap.get(pattern));
                    newSet.remove(this.itemData.getIdentifier());
                    newMap.put(pattern, newSet);
                }
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, newMap);
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    public static class AddToPatternListContainer
    extends ChangesContainer {
        private final ItemData itemData;

        public AddToPatternListContainer(CacheKey key, ItemData value, AdvancedCache<CacheKey, Object> cache, int historicalIndex, boolean local, Boolean allowLocalChanges) {
            super(key, ChangesType.PUT, cache, historicalIndex, local, allowLocalChanges);
            this.itemData = value;
        }

        @Override
        public void apply() {
            if (!this.localMode && this.cache.getRpcManager() != null && this.cache.getCacheManager().getMembers().size() > 1) {
                this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES}).remove((Object)this.key);
                return;
            }
            Object existingObject = this.cache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)this.key);
            if (existingObject instanceof Map) {
                HashMap<QPathEntryFilter, Set> newMap = new HashMap<QPathEntryFilter, Set>((Map)existingObject);
                for (QPathEntryFilter pattern : newMap.keySet()) {
                    if (!pattern.accept(this.itemData)) continue;
                    Set newSet = (Set)newMap.get(pattern);
                    newSet.add(this.itemData.getIdentifier());
                    newMap.put(pattern, newSet);
                }
                this.setCacheLocalMode(Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES).put((Object)this.key, newMap);
            } else if (existingObject != null) {
                LOG.error((Object)("Unexpected object found by key " + this.key.toString() + ". Expected Map, but found:" + existingObject.getClass().getName()));
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    public static enum ChangesType {
        REMOVE,
        PUT;

    }
}

