/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventAttendeeList;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventPermission;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.rest.model.EventAttendeeEntity;
import org.exoplatform.agenda.rest.model.EventDateOptionEntity;
import org.exoplatform.agenda.rest.model.EventEntity;
import org.exoplatform.agenda.rest.model.EventReminderEntity;
import org.exoplatform.agenda.rest.model.EventSearchResultEntity;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.RestEntityBuilder;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.entity.IdentityEntity;

public class RestUtils {
    private RestUtils() {
    }

    public static final String getCurrentUser() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    public static final Identity getCurrentUserIdentity(IdentityManager identityManager) {
        String currentUser = RestUtils.getCurrentUser();
        return identityManager.getOrCreateIdentity("organization", currentUser);
    }

    public static final long getCurrentUserIdentityId(IdentityManager identityManager) {
        String currentUser = RestUtils.getCurrentUser();
        Identity identity = identityManager.getOrCreateIdentity("organization", currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    public static String getBaseRestURI() {
        return RestUtils.getBasePortalURI() + "/" + PortalContainer.getCurrentRestContextName();
    }

    public static String getBasePortalURI() {
        return "/" + PortalContainer.getCurrentPortalContainerName();
    }

    public static String getIdentityId(IdentityEntity identityEntity, IdentityManager identityManager) {
        Identity identity;
        if (identityEntity == null) {
            return null;
        }
        String identityIdString = identityEntity.getId();
        String remoteId = identityEntity.getRemoteId();
        String providerId = identityEntity.getProviderId();
        if (StringUtils.isNotBlank((CharSequence)identityIdString) && (identity = identityManager.getIdentity(identityIdString)) == null) {
            identityIdString = null;
        }
        if (StringUtils.isBlank((CharSequence)identityIdString) && StringUtils.isNotBlank((CharSequence)remoteId) && StringUtils.isNotBlank((CharSequence)providerId) && (identity = identityManager.getOrCreateIdentity(providerId, remoteId)) != null) {
            identityIdString = identity.getId();
        }
        return identityIdString;
    }

    public static Integer getIntegerValue(UriInfo uriInfo, String name) {
        String value = RestUtils.getQueryParam(uriInfo, name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getQueryParam(UriInfo uriInfo, String name) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)name);
    }

    public static Event createEventEntity(IdentityManager identityManager, AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, EventEntity eventEntity, long userIdentityId, String timeZoneId) throws AgendaException, IllegalAccessException {
        RestUtils.checkCalendar(identityManager, agendaCalendarService, eventEntity);
        RestUtils.cleanupAttachedEntitiesIds(eventEntity);
        List attendeeEntities = eventEntity.getAttendees();
        ArrayList<EventAttendee> attendees = null;
        if (attendeeEntities != null && !attendeeEntities.isEmpty()) {
            attendees = new ArrayList<EventAttendee>();
            for (EventAttendeeEntity attendeeEntity : attendeeEntities) {
                IdentityEntity attendeeIdentity = attendeeEntity.getIdentity();
                String attendeeIdString = RestUtils.getIdentityId(attendeeIdentity, identityManager);
                if (StringUtils.isBlank((CharSequence)attendeeIdString)) {
                    throw new AgendaException(AgendaExceptionType.ATTENDEE_IDENTITY_NOT_FOUND);
                }
                attendeeIdentity.setId(attendeeIdString);
                attendees.add(RestEntityBuilder.toEventAttendee(identityManager, eventEntity.getId(), attendeeEntity));
            }
        }
        List reminderEntities = eventEntity.getReminders();
        ArrayList<EventReminder> reminders = null;
        if (reminderEntities != null && !reminderEntities.isEmpty()) {
            reminders = new ArrayList<EventReminder>();
            for (EventReminderEntity reminderEntity : reminderEntities) {
                reminders.add(RestEntityBuilder.toEventReminder(eventEntity.getId(), reminderEntity));
            }
        }
        RemoteEvent remoteEvent = RestUtils.getRemoteEvent(eventEntity, userIdentityId);
        String userTimeZoneId = timeZoneId == null ? eventEntity.getTimeZoneId() : timeZoneId;
        ZoneId userTimeZone = userTimeZoneId == null ? ZoneOffset.UTC : ZoneId.of(userTimeZoneId);
        List dateOptionEntities = eventEntity.getDateOptions();
        List dateOptions = dateOptionEntities == null ? Collections.emptyList() : dateOptionEntities.stream().map(dateOptionEntity -> RestEntityBuilder.toEventDateOption(dateOptionEntity, userTimeZone)).collect(Collectors.toList());
        return agendaEventService.createEvent(RestEntityBuilder.toEvent(eventEntity), attendees, eventEntity.getConferences(), reminders, dateOptions, remoteEvent, eventEntity.isSendInvitation(), userIdentityId);
    }

    public static void checkCalendar(IdentityManager identityManager, AgendaCalendarService agendaCalendarService, EventEntity eventEntity) throws AgendaException {
        IdentityEntity identityEntity = eventEntity.getCalendar().getOwner();
        String ownerIdString = RestUtils.getIdentityId(identityEntity, identityManager);
        if (StringUtils.isBlank((CharSequence)ownerIdString)) {
            throw new AgendaException(AgendaExceptionType.CALENDAR_OWNER_NOT_FOUND);
        }
        identityEntity.setId(ownerIdString);
        Calendar calendar = agendaCalendarService.getOrCreateCalendarByOwnerId(Long.parseLong(ownerIdString));
        if (calendar == null) {
            throw new AgendaException(AgendaExceptionType.CALENDAR_NOT_FOUND);
        }
        if (eventEntity.getCalendar() == null) {
            eventEntity.setCalendar(RestEntityBuilder.fromCalendar(identityManager, calendar));
        } else {
            eventEntity.getCalendar().setId(calendar.getId());
        }
    }

    public static EventEntity getEventByIdAndUser(IdentityManager identityManager, AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, AgendaRemoteEventService agendaRemoteEventService, AgendaEventDatePollService agendaEventDatePollService, AgendaEventReminderService agendaEventReminderService, AgendaEventConferenceService agendaEventConferenceService, AgendaEventAttendeeService agendaEventAttendeeService, long eventId, boolean firstOccurrence, long identityId, ZonedDateTime occurrenceId, ZoneId userTimeZone, List<String> expandProperties) throws IllegalAccessException {
        LocalDate occurrencesFromDate;
        List<Event> occurrences;
        Event event = agendaEventService.getEventById(eventId, userTimeZone, identityId);
        if (event.getRecurrence() != null && firstOccurrence && CollectionUtils.isNotEmpty(occurrences = Utils.getOccurrences(event, occurrencesFromDate = event.getStart().toLocalTime().isAfter(ZonedDateTime.now().toLocalTime()) ? LocalDate.from(ZonedDateTime.now()) : LocalDate.from(ZonedDateTime.now()).plusDays(1L), null, 1))) {
            event = occurrences.get(0);
            occurrenceId = event.getOccurrence().getId();
        }
        return RestUtils.getEventEntity(identityManager, agendaCalendarService, agendaEventService, agendaRemoteEventService, agendaEventDatePollService, agendaEventReminderService, agendaEventConferenceService, agendaEventAttendeeService, event, occurrenceId, userTimeZone, expandProperties);
    }

    public static EventEntity getEventEntity(IdentityManager identityManager, AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, AgendaRemoteEventService agendaRemoteEventService, AgendaEventDatePollService agendaEventDatePollService, AgendaEventReminderService agendaEventReminderService, AgendaEventConferenceService agendaEventConferenceService, AgendaEventAttendeeService agendaEventAttendeeService, Event event, ZonedDateTime occurrenceId, ZoneId userTimeZone, List<String> expandProperties) {
        if (event == null) {
            return null;
        }
        if (userTimeZone == null) {
            userTimeZone = event.getTimeZoneId() == null ? ZoneOffset.UTC : event.getTimeZoneId();
        }
        EventEntity eventEntity = RestEntityBuilder.fromEvent(agendaCalendarService, agendaEventService, identityManager, event, userTimeZone);
        long userIdentityId = RestUtils.getCurrentUserIdentityId(identityManager);
        if (expandProperties.contains("all") || expandProperties.contains("attendees")) {
            RestUtils.fillAttendees(identityManager, agendaEventAttendeeService, eventEntity, occurrenceId, 0L);
        } else if (expandProperties.contains("response")) {
            RestUtils.fillAttendees(identityManager, agendaEventAttendeeService, eventEntity, occurrenceId, userIdentityId);
        }
        if (expandProperties.contains("all") || expandProperties.contains("conferences")) {
            RestUtils.fillConferences(agendaEventConferenceService, eventEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("reminders")) {
            RestUtils.fillReminders(agendaEventReminderService, eventEntity, userIdentityId);
        }
        if (expandProperties.contains("all") || expandProperties.contains("dateOptions")) {
            RestUtils.fillDateOptions(agendaEventDatePollService, eventEntity, userTimeZone);
        }
        RestUtils.fillRemoteEvent(agendaRemoteEventService, eventEntity, userIdentityId);
        boolean isComputedOccurrence = RestUtils.isComputedOccurrence(eventEntity);
        EventEntity parentEventEntity = eventEntity.getParent();
        if (parentEventEntity != null) {
            RestUtils.fillRemoteEvent(agendaRemoteEventService, parentEventEntity, userIdentityId);
            if (expandProperties.contains("parentAll") && !isComputedOccurrence) {
                boolean isEventAttendee = agendaEventAttendeeService.isEventAttendee(parentEventEntity.getId(), userIdentityId);
                boolean canUpdateEvent = isEventAttendee && eventEntity.getAcl().isCanEdit();
                parentEventEntity.setAcl(new EventPermission(canUpdateEvent, isEventAttendee));
            }
        }
        if (isComputedOccurrence) {
            RestUtils.cleanupAttachedEntitiesIds(eventEntity);
        }
        return eventEntity;
    }

    public static EventSearchResultEntity getEventSearchResultEntity(IdentityManager identityManager, AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, AgendaRemoteEventService agendaRemoteEventService, AgendaEventDatePollService agendaEventDatePollService, AgendaEventReminderService agendaEventReminderService, AgendaEventConferenceService agendaEventConferenceService, AgendaEventAttendeeService agendaEventAttendeeService, EventSearchResult eventSearchResult, ZonedDateTime occurrenceId, ZoneId userTimeZone, List<String> expandProperties) {
        if (eventSearchResult == null) {
            return null;
        }
        EventSearchResultEntity eventSearchResultEntity = RestEntityBuilder.fromSearchEvent(agendaCalendarService, agendaEventService, identityManager, eventSearchResult, userTimeZone);
        long userIdentityId = RestUtils.getCurrentUserIdentityId(identityManager);
        if (expandProperties.contains("all") || expandProperties.contains("attendees")) {
            RestUtils.fillAttendees(identityManager, agendaEventAttendeeService, (EventEntity)eventSearchResultEntity, occurrenceId, 0L);
        } else if (expandProperties.contains("response")) {
            RestUtils.fillAttendees(identityManager, agendaEventAttendeeService, (EventEntity)eventSearchResultEntity, occurrenceId, userIdentityId);
        }
        if (expandProperties.contains("all") || expandProperties.contains("conferences")) {
            RestUtils.fillConferences(agendaEventConferenceService, (EventEntity)eventSearchResultEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("reminders")) {
            RestUtils.fillReminders(agendaEventReminderService, (EventEntity)eventSearchResultEntity, userIdentityId);
        }
        if (expandProperties.contains("all") || expandProperties.contains("dateOptions")) {
            RestUtils.fillDateOptions(agendaEventDatePollService, (EventEntity)eventSearchResultEntity, userTimeZone);
        }
        RestUtils.fillRemoteEvent(agendaRemoteEventService, (EventEntity)eventSearchResultEntity, userIdentityId);
        if (eventSearchResultEntity.getParent() != null) {
            RestUtils.fillRemoteEvent(agendaRemoteEventService, eventSearchResultEntity.getParent(), userIdentityId);
        }
        if (RestUtils.isComputedOccurrence((EventEntity)eventSearchResultEntity)) {
            RestUtils.cleanupAttachedEntitiesIds((EventEntity)eventSearchResultEntity);
        }
        return eventSearchResultEntity;
    }

    public static void fillAttendees(IdentityManager identityManager, AgendaEventAttendeeService agendaEventAttendeeService, EventEntity eventEntity, ZonedDateTime occurrenceId, Map<Long, EventAttendeeList> attendeesByParentEventId, long userIdentityId) {
        long eventId;
        boolean computedOccurrence = RestUtils.isComputedOccurrence(eventEntity);
        long l = eventId = computedOccurrence ? eventEntity.getParent().getId() : eventEntity.getId();
        if (computedOccurrence && attendeesByParentEventId.containsKey(eventId)) {
            EventAttendeeList eventAttendeeList = attendeesByParentEventId.get(eventId);
            List eventAttendees = eventAttendeeList.getEventAttendees(occurrenceId);
            eventEntity.setAttendees(eventAttendees.stream().map(eventAttendee -> RestEntityBuilder.fromEventAttendee(identityManager, eventAttendee)).collect(Collectors.toList()));
        } else {
            EventAttendeeList eventAttendeeList = RestUtils.fillAttendees(identityManager, agendaEventAttendeeService, eventEntity, occurrenceId, userIdentityId);
            if (eventEntity.getRecurrence() != null) {
                attendeesByParentEventId.put(eventId, eventAttendeeList);
            }
        }
    }

    private static EventAttendeeList fillAttendees(IdentityManager identityManager, AgendaEventAttendeeService agendaEventAttendeeService, EventEntity eventEntity, ZonedDateTime occurrenceId, long userIdentityId) {
        boolean computedOccurrence = RestUtils.isComputedOccurrence(eventEntity);
        long eventId = computedOccurrence ? eventEntity.getParent().getId() : eventEntity.getId();
        EventAttendeeList eventAttendeeList = agendaEventAttendeeService.getEventAttendees(eventId);
        if (userIdentityId > 0L) {
            EventAttendee eventAttendee2 = eventAttendeeList.getEventAttendee(userIdentityId, occurrenceId);
            if (eventAttendee2 == null) {
                eventEntity.setAttendees(Collections.emptyList());
            } else {
                eventEntity.setAttendees(Collections.singletonList(RestEntityBuilder.fromEventAttendee(identityManager, eventAttendee2)));
            }
        } else {
            List eventAttendeeEntities = eventAttendeeList.getEventAttendees(occurrenceId).stream().map(eventAttendee -> RestEntityBuilder.fromEventAttendee(identityManager, eventAttendee)).collect(Collectors.toList());
            eventEntity.setAttendees(eventAttendeeEntities);
        }
        return eventAttendeeList;
    }

    public static void fillConferences(AgendaEventConferenceService agendaEventConferenceService, EventEntity eventEntity, Map<Long, List<EventConference>> conferencesByParentEventId) {
        long eventId;
        long l = eventId = RestUtils.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        if (conferencesByParentEventId.containsKey(eventId)) {
            eventEntity.setConferences(conferencesByParentEventId.get(eventId));
        } else {
            RestUtils.fillConferences(agendaEventConferenceService, eventEntity);
            conferencesByParentEventId.put(eventId, eventEntity.getConferences());
        }
    }

    private static void fillConferences(AgendaEventConferenceService agendaEventConferenceService, EventEntity eventEntity) {
        long eventId = RestUtils.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        List eventConferences = agendaEventConferenceService.getEventConferences(eventId);
        eventEntity.setConferences(eventConferences);
    }

    public static void fillReminders(AgendaEventReminderService agendaEventReminderService, EventEntity eventEntity, long userIdentityId, Map<Long, List<EventReminder>> remindersByParentEventId) {
        long eventId;
        long l = eventId = RestUtils.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        if (remindersByParentEventId.containsKey(eventId)) {
            List<Object> reminders = remindersByParentEventId.get(eventId);
            ZonedDateTime occurrenceId = AgendaDateUtils.parseRFC3339ToZonedDateTime(eventEntity.getOccurrence().getId(), ZoneOffset.UTC);
            reminders = reminders.stream().filter(reminder -> !(reminder.getFromOccurrenceId() != null && !reminder.getFromOccurrenceId().isEqual(occurrenceId) && !reminder.getFromOccurrenceId().isBefore(occurrenceId) || reminder.getUntilOccurrenceId() != null && !reminder.getUntilOccurrenceId().isAfter(occurrenceId))).collect(Collectors.toList());
            eventEntity.setReminders(reminders.stream().map(RestEntityBuilder::fromEventReminder).collect(Collectors.toList()));
        } else {
            RestUtils.fillReminders(agendaEventReminderService, eventEntity, userIdentityId);
            remindersByParentEventId.put(eventId, eventEntity.getReminders().stream().map(reminderEntity -> RestEntityBuilder.toEventReminder(eventId, reminderEntity)).collect(Collectors.toList()));
        }
    }

    public static void fillDateOptions(AgendaEventDatePollService agendaEventDatePollService, EventEntity eventEntity, ZoneId userTimeZone, Map<Long, List<EventDateOptionEntity>> dateOptionsByParentEventId) {
        long eventId;
        long l = eventId = RestUtils.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        if (dateOptionsByParentEventId.containsKey(eventId)) {
            eventEntity.setDateOptions(dateOptionsByParentEventId.get(eventId));
        } else {
            RestUtils.fillDateOptions(agendaEventDatePollService, eventEntity, userTimeZone);
            dateOptionsByParentEventId.put(eventId, eventEntity.getDateOptions());
        }
    }

    public static void fillRemoteEvent(AgendaRemoteEventService agendaRemoteEventService, EventEntity eventEntity, long userIdentityId) {
        if (RestUtils.isComputedOccurrence(eventEntity)) {
            return;
        }
        long eventId = eventEntity.getId();
        RemoteEvent remoteEvent = agendaRemoteEventService.findRemoteEvent(eventId, userIdentityId);
        if (remoteEvent != null) {
            eventEntity.setRemoteId(remoteEvent.getRemoteId());
            eventEntity.setRemoteProviderId(remoteEvent.getRemoteProviderId());
            eventEntity.setRemoteProviderName(remoteEvent.getRemoteProviderName());
        }
    }

    public static void fillRemoteEvent(AgendaRemoteEventService agendaRemoteEventService, EventEntity eventEntity, long userIdentityId, Map<Long, RemoteEvent> remoteEventByParentEventId) {
        if (RestUtils.isComputedOccurrence(eventEntity)) {
            return;
        }
        long eventId = eventEntity.getId();
        RemoteEvent remoteEvent = null;
        if (remoteEventByParentEventId.containsKey(eventId)) {
            remoteEvent = remoteEventByParentEventId.get(eventId);
        } else {
            remoteEvent = agendaRemoteEventService.findRemoteEvent(eventId, userIdentityId);
            remoteEventByParentEventId.put(eventId, remoteEvent);
        }
        if (remoteEvent != null) {
            eventEntity.setRemoteId(remoteEvent.getRemoteId());
            eventEntity.setRemoteProviderId(remoteEvent.getRemoteProviderId());
            eventEntity.setRemoteProviderName(remoteEvent.getRemoteProviderName());
        }
    }

    public static RemoteEvent getRemoteEvent(EventEntity eventEntity, long userIdentityId) {
        return new RemoteEvent(0L, eventEntity.getId(), userIdentityId, eventEntity.getRemoteId(), eventEntity.getRemoteProviderId(), eventEntity.getRemoteProviderName());
    }

    public static void fillReminders(AgendaEventReminderService agendaEventReminderService, EventEntity eventEntity, long userIdentityId) {
        boolean computedOccurrence = RestUtils.isComputedOccurrence(eventEntity);
        long eventId = computedOccurrence ? eventEntity.getParent().getId() : eventEntity.getId();
        List reminders = agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        if (computedOccurrence) {
            ZonedDateTime occurrenceId = AgendaDateUtils.parseRFC3339ToZonedDateTime(eventEntity.getOccurrence().getId(), ZoneOffset.UTC);
            reminders = reminders.stream().filter(reminder -> !(reminder.getFromOccurrenceId() != null && !reminder.getFromOccurrenceId().isEqual(occurrenceId) && !reminder.getFromOccurrenceId().isBefore(occurrenceId) || reminder.getUntilOccurrenceId() != null && !reminder.getUntilOccurrenceId().isAfter(occurrenceId))).collect(Collectors.toList());
        }
        List eventReminderEntities = reminders == null ? null : reminders.stream().map(RestEntityBuilder::fromEventReminder).collect(Collectors.toList());
        eventEntity.setReminders(eventReminderEntities);
    }

    private static void fillDateOptions(AgendaEventDatePollService agendaEventDatePollService, EventEntity eventEntity, ZoneId userTimeZone) {
        long eventId = RestUtils.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        List dateOptions = agendaEventDatePollService.getEventDateOptions(eventId, userTimeZone);
        List dateOptionEntities = dateOptions == null ? Collections.emptyList() : dateOptions.stream().map(dateOption -> RestEntityBuilder.fromEventDateOption(userTimeZone, dateOption)).collect(Collectors.toList());
        eventEntity.setDateOptions(dateOptionEntities);
    }

    public static boolean isComputedOccurrence(EventEntity eventEntity) {
        return eventEntity.getId() == 0L && eventEntity.getParent() != null;
    }

    public static void cleanupAttachedEntitiesIds(EventEntity eventEntity) {
        List reminders;
        List conferences;
        List attendees = eventEntity.getAttendees();
        if (attendees != null && !attendees.isEmpty()) {
            attendees = attendees.stream().map(attendee -> {
                attendee = attendee.clone();
                attendee.setId(0L);
                return attendee;
            }).collect(Collectors.toList());
            eventEntity.setAttendees(attendees);
        }
        if ((conferences = eventEntity.getConferences()) != null && !conferences.isEmpty()) {
            conferences = conferences.stream().map(conference -> {
                conference = conference.clone();
                conference.setId(0L);
                return conference;
            }).collect(Collectors.toList());
            eventEntity.setConferences(conferences);
        }
        if ((reminders = eventEntity.getReminders()) != null && !reminders.isEmpty()) {
            reminders = reminders.stream().map(reminder -> {
                reminder = reminder.clone();
                reminder.setId(0L);
                return reminder;
            }).collect(Collectors.toList());
            eventEntity.setReminders(reminders);
        }
    }
}

