/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotContainBinaryFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsVersionableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsVersionableOrAncestorFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={CheckInActionListener.class})})
public class CheckInManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsVersionableOrAncestorFilter(), new IsCheckedOutFilter(), new IsVersionableFilter(), new IsNotTrashHomeNodeFilter(), new IsNotContainBinaryFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void checkInManage(Event<? extends UIComponent> event, UIJCRExplorer uiExplorer, UIApplication uiApp) throws Exception {
        Object nodePath = event.getRequestContext().getRequestParameter("objectId");
        if (nodePath == null) {
            nodePath = uiExplorer.getCurrentWorkspace() + ":" + uiExplorer.getCurrentPath();
        }
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher((CharSequence)nodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + (String)nodePath + "'");
        }
        wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node node = uiExplorer.getNodeByPath((String)nodePath, session);
        nodePath = node.getPath();
        session = node.getSession();
        wsName = session.getWorkspace().getName();
        try {
            Node parentNode = node.getParent();
            uiExplorer.addLockToken(parentNode);
            node.checkin();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (AccessDeniedException adEx) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-checkin-node", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class CheckInActionListener
    extends UIWorkingAreaActionListener<CheckInManageComponent> {
        public void processEvent(Event<CheckInManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((CheckInManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)((CheckInManageComponent)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
            CheckInManageComponent.checkInManage(event, uiExplorer, uiApp);
        }
    }
}

