/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.application.PortalStatistic;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="The portal statistic service")
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="statistic"), @Property(key="type", value="portal")})
@RESTEndpoint(path="portalstatistic")
public class PortalStatisticService
implements Startable {
    private ConcurrentMap<String, PortalStatistic> apps = new ConcurrentHashMap<String, PortalStatistic>();
    private UserPortalConfigService configService;
    private final Log log = ExoLogger.getLogger(PortalStatisticService.class);

    public PortalStatisticService(UserPortalConfigService res) {
        this.configService = res;
    }

    protected PortalStatistic findPortalStatistic(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Parameter 'portalId' is required.");
        }
        PortalStatistic result = (PortalStatistic)this.apps.get(name);
        if (result == null) {
            String safeName = name.replaceAll("[^a-zA-Z0-9_\\-\\./]+", "");
            throw new IllegalArgumentException("There is no such portal with portalId '" + safeName + "'.");
        }
        return result;
    }

    public PortalStatistic getPortalStatistic(String appId) {
        PortalStatistic existing;
        PortalStatistic app = (PortalStatistic)this.apps.get(appId);
        if (app == null && (existing = this.apps.putIfAbsent(appId, app = new PortalStatistic(appId))) != null) {
            app = existing;
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of a specified portal in seconds")
    @Impact(value=ImpactType.READ)
    public double getMaxTime(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.toSeconds(this.findPortalStatistic(id).getMaxTime());
    }

    @Managed
    @ManagedDescription(value="The mininum execution time of a specified portal in seconds")
    @Impact(value=ImpactType.READ)
    public double getMinTime(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.toSeconds(this.findPortalStatistic(id).getMinTime());
    }

    @Managed
    @ManagedDescription(value="The average execution time of a specified portal in seconds")
    @Impact(value=ImpactType.READ)
    public double getAverageTime(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.toSeconds(this.findPortalStatistic(id).getAverageTime());
    }

    @Managed
    @ManagedDescription(value="The number of request per second of a specified portal")
    @Impact(value=ImpactType.READ)
    public double getThroughput(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.findPortalStatistic(id).getThroughput();
    }

    @Managed
    @ManagedDescription(value="The execution count of a specified portal")
    @Impact(value=ImpactType.READ)
    public long getExecutionCount(@ManagedDescription(value="The portal id") @ManagedName(value="portalId") String id) {
        return this.findPortalStatistic(id).viewCount();
    }

    private double toSeconds(double value) {
        return value == -1.0 ? -1.0 : value / 1000.0;
    }

    public void start() {
    }

    public void stop() {
    }
}

