/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api.http;

import com.deepl.api.DeepLException;
import com.deepl.api.http.HttpResponse;
import com.deepl.api.utils.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;

public class HttpResponseStream
implements AutoCloseable {
    private final int code;
    @Nullable
    private final InputStream body;

    public HttpResponseStream(int code, @Nullable InputStream body) {
        this.code = code;
        this.body = body;
    }

    @Override
    public void close() {
        try {
            if (this.body != null) {
                this.body.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HttpResponse toStringResponse() throws DeepLException {
        try {
            String content = this.body == null ? "" : StreamUtil.readStream(this.body);
            HttpResponse httpResponse = new HttpResponse(this.getCode(), content);
            return httpResponse;
        }
        catch (IOException exception) {
            throw new DeepLException("Error reading stream", exception);
        }
        finally {
            this.close();
        }
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public InputStream getBody() {
        return this.body;
    }
}

