/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.PermissionPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class PermissionValueData
extends AbstractValueData {
    protected AccessControlEntry value;

    protected PermissionValueData(int orderNumber, AccessControlEntry value) {
        super(orderNumber);
        this.value = value;
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof PermissionValueData) {
            return ((PermissionValueData)another).value.equals(this.value);
        }
        return false;
    }

    @Override
    protected byte[] spoolInternalValue() {
        try {
            return this.value.getAsString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    public String toString() {
        return this.value.getAsString();
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new PermissionPersistedValueData(orderNumber, this.value);
    }

    @Override
    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    @Override
    protected String getString() {
        return this.value.getAsString();
    }

    @Override
    protected AccessControlEntry getPermission() {
        return this.value;
    }
}

