/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public class IfElseStatement
implements Statement {
    private final Expression condition;
    private final Statement ifStatement;
    private Statement elseStatement;
    private boolean usingSemicolonForIfStatement = false;
    private boolean usingSemicolonForElseStatement = false;

    public IfElseStatement(Expression expression, Statement statement) {
        this.condition = Objects.requireNonNull(expression, "The CONDITION of the IfElseStatement must not be null.");
        this.ifStatement = Objects.requireNonNull(statement, "The IF Statement of the IfElseStatement must not be null.");
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getIfStatement() {
        return this.ifStatement;
    }

    public void setElseStatement(Statement statement) {
        this.elseStatement = statement;
    }

    public Statement getElseStatement() {
        return this.elseStatement;
    }

    public void setUsingSemicolonForElseStatement(boolean bl2) {
        this.usingSemicolonForElseStatement = bl2;
    }

    public boolean isUsingSemicolonForElseStatement() {
        return this.usingSemicolonForElseStatement;
    }

    public void setUsingSemicolonForIfStatement(boolean bl2) {
        this.usingSemicolonForIfStatement = bl2;
    }

    public boolean isUsingSemicolonForIfStatement() {
        return this.usingSemicolonForIfStatement;
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("IF ").append(this.condition).append(" ").append(this.ifStatement).append(this.usingSemicolonForIfStatement ? ";" : "");
        if (this.elseStatement != null) {
            stringBuilder.append(" ELSE ").append(this.elseStatement).append(this.usingSemicolonForElseStatement ? ";" : "");
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }
}

