/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest.content;

import javax.ws.rs.core.UriBuilder;
import org.gatein.management.rest.content.Link;

public class LinkBuilder {
    private UriBuilder uriBuilder;
    private String rel;
    private String type;
    private String method;

    public static LinkBuilder fromLink(Link link) {
        return new LinkBuilder(UriBuilder.fromUri((String)link.getHref())).rel(link.getRel()).type(link.getType()).method(link.getMethod());
    }

    public LinkBuilder(UriBuilder uriBuilder) {
        String uri = uriBuilder.build(new Object[0]).toString();
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        this.uriBuilder = UriBuilder.fromUri((String)uri);
    }

    public LinkBuilder rel(String rel) {
        this.rel = rel;
        return this;
    }

    public LinkBuilder type(String type) {
        this.type = type;
        return this;
    }

    public LinkBuilder method(String method) {
        this.method = method;
        return this;
    }

    public LinkBuilder extension(String extension) throws IllegalArgumentException {
        String uri = this.uriBuilder.build(new Object[0]).toString();
        int queryStart = uri.indexOf("?");
        if (queryStart == -1) {
            uri = uri + "." + extension;
        } else {
            String beforeQuery = uri.substring(0, queryStart);
            String afterQuery = uri.substring(queryStart, uri.length());
            uri = beforeQuery + "." + extension + afterQuery;
        }
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    public LinkBuilder path(String path) throws IllegalArgumentException {
        this.uriBuilder.path(path);
        return this;
    }

    public LinkBuilder replaceQuery(String query) throws IllegalArgumentException {
        this.uriBuilder.replaceQuery(query);
        return this;
    }

    public LinkBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        this.uriBuilder.queryParam(name, values);
        return this;
    }

    public LinkBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        this.uriBuilder.replaceQueryParam(name, values);
        return this;
    }

    public LinkBuilder copy() {
        return LinkBuilder.fromLink(this.build());
    }

    public Link build() {
        return new Link(this.rel, this.uriBuilder.build(new Object[0]).toString(), this.type, this.method);
    }
}

