/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.user.HttpUserPortalContext;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.picocontainer.Startable;

public class UserPortalConfigService
implements Startable {
    private static final String PUBLIC_SITE_NAME = "public";
    private static final Scope HOME_PAGE_URI_PREFERENCE_SCOPE = Scope.PORTAL.id("HOME");
    private static final String HOME_PAGE_URI_PREFERENCE_KEY = "HOME_PAGE_URI";
    public static final String DEFAULT_GLOBAL_PORTAL = "global";
    public static final String DEFAULT_GROUP_SITE_TEMPLATE = "group";
    public static final String DEFAULT_USER_SITE_TEMPLATE = "user";
    protected final SiteFilter siteFilter = new SiteFilter(SiteType.PORTAL, null, null, true, true, false, false, 0, 0);
    LayoutService layoutService;
    UserACL userACL_;
    OrganizationService orgService_;
    private SettingService settingService;
    private NewPortalConfigListener newPortalConfigListener_;
    final NavigationService navigationService;
    final DescriptionStorage descriptionStorage;
    final PageStorage pageStorage;
    boolean createUserPortal;
    boolean destroyUserPortal;
    String globalPortal_;
    String defaultGroupSiteTemplate;
    String defaultUserSiteTemplate;
    private final ImportMode defaultImportMode;
    private PortalConfig metaPortalConfig;
    private Log log = ExoLogger.getLogger((String)"Portal:UserPortalConfigService");
    private static final UserPortalContext NULL_CONTEXT = new UserPortalContext(){

        @Override
        public ResourceBundle getBundle(UserNavigation navigation) {
            return null;
        }

        @Override
        public Locale getUserLocale() {
            return Locale.ENGLISH;
        }
    };

    public UserPortalConfigService(UserACL userACL, LayoutService storage, OrganizationService orgService, NavigationService navService, DescriptionStorage descriptionService, PageStorage pageStorage, SettingService settingService, InitParams params) {
        ValueParam createUserPortalParam = params == null ? null : params.getValueParam("create.user.portal");
        boolean createUserPortal = createUserPortalParam == null || createUserPortalParam.getValue().toLowerCase().trim().equals("true");
        ValueParam destroyUserPortalParam = params == null ? null : params.getValueParam("destroy.user.portal");
        boolean destroyUserPortal = destroyUserPortalParam == null || destroyUserPortalParam.getValue().toLowerCase().trim().equals("true");
        ValueParam defaultImportModeParam = params == null ? null : params.getValueParam("default.import.mode");
        ImportMode defaultImportMode = defaultImportModeParam == null ? ImportMode.CONSERVE : ImportMode.valueOf((String)defaultImportModeParam.getValue().toUpperCase().trim());
        ValueParam globalPortalParam = params == null ? null : params.getValueParam("global.portal");
        this.globalPortal_ = globalPortalParam == null ? DEFAULT_GLOBAL_PORTAL : globalPortalParam.getValue();
        ValueParam defaultGroupSiteTemplateParam = params == null ? null : params.getValueParam("default.groupSite.template");
        String defaultGroupSiteTemplate = defaultGroupSiteTemplateParam == null ? DEFAULT_GROUP_SITE_TEMPLATE : defaultGroupSiteTemplateParam.getValue();
        ValueParam defaultUserSiteTemplateParam = params == null ? null : params.getValueParam("default.userSite.template");
        String defaultUserSiteTemplate = defaultUserSiteTemplateParam == null ? DEFAULT_USER_SITE_TEMPLATE : defaultUserSiteTemplateParam.getValue();
        this.layoutService = storage;
        this.orgService_ = orgService;
        this.settingService = settingService;
        this.userACL_ = userACL;
        this.navigationService = navService;
        this.descriptionStorage = descriptionService;
        this.pageStorage = pageStorage;
        this.createUserPortal = createUserPortal;
        this.destroyUserPortal = destroyUserPortal;
        this.defaultImportMode = defaultImportMode;
        this.defaultGroupSiteTemplate = defaultGroupSiteTemplate;
        this.defaultUserSiteTemplate = defaultUserSiteTemplate;
        this.siteFilter.setExcludedSiteName(this.globalPortal_);
    }

    public PageStorage getPageService() {
        return this.pageStorage;
    }

    public LayoutService getDataStorage() {
        return this.layoutService;
    }

    public ImportMode getDefaultImportMode() {
        return this.defaultImportMode;
    }

    public boolean getCreateUserPortal() {
        return this.createUserPortal;
    }

    public void setCreateUserPortal(boolean createUserPortal) {
        this.createUserPortal = createUserPortal;
    }

    public boolean getDestroyUserPortal() {
        return this.destroyUserPortal;
    }

    public void setDestroyUserPortal(boolean destroyUserPortal) {
        this.destroyUserPortal = destroyUserPortal;
    }

    public String getDefaultGroupSiteTemplate() {
        return this.defaultGroupSiteTemplate;
    }

    public void setDefaultGroupSiteTemplate(String defaultGroupSiteTemplate) {
        this.defaultGroupSiteTemplate = defaultGroupSiteTemplate;
    }

    public String getDefaultUserSiteTemplate() {
        return this.defaultUserSiteTemplate;
    }

    public void setDefaultUserSiteTemplate(String defaultUserSiteTemplate) {
        this.defaultUserSiteTemplate = defaultUserSiteTemplate;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public DescriptionStorage getDescriptionService() {
        return this.descriptionStorage;
    }

    public UserACL getUserACL() {
        return this.userACL_;
    }

    public OrganizationService getOrganizationService() {
        return this.orgService_;
    }

    @Deprecated
    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser) throws Exception {
        return this.getUserPortalConfig(portalName, accessUser, NULL_CONTEXT);
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser, UserPortalContext userPortalContext) throws Exception {
        PortalConfig portal = this.layoutService.getPortalConfig(portalName);
        if (portal == null || !this.userACL_.hasPermission(portal)) {
            return null;
        }
        return new UserPortalConfig(portal, this, portalName, accessUser, userPortalContext);
    }

    public List<String> getMakableNavigations(String remoteUser, boolean withSite) throws Exception {
        Collection groups = remoteUser.equals(this.userACL_.getSuperUser()) ? this.orgService_.getGroupHandler().getAllGroups() : this.orgService_.getGroupHandler().resolveGroupByMembership(remoteUser, this.userACL_.getMakableMT());
        ArrayList<String> list = new ArrayList<String>();
        if (groups != null) {
            HashSet<String> existingNames = null;
            if (withSite) {
                existingNames = new HashSet<String>();
                Query q = new Query(DEFAULT_GROUP_SITE_TEMPLATE, null, PortalConfig.class);
                LazyPageList lpl = this.layoutService.find(q, null);
                for (PortalConfig groupSite : lpl.getAll()) {
                    existingNames.add(groupSite.getName());
                }
            }
            for (Group group : groups) {
                String groupId = group.getId().trim();
                if (existingNames != null && !existingNames.contains(groupId)) continue;
                list.add(groupId);
            }
        }
        return list;
    }

    public boolean hasMakableNavigations(String remoteUser, boolean withSite) throws Exception {
        boolean hasNav = false;
        if (remoteUser == null) {
            hasNav = false;
        } else if (remoteUser.equals(this.userACL_.getSuperUser())) {
            hasNav = true;
        } else {
            Collection groups = this.orgService_.getGroupHandler().resolveGroupByMembership(remoteUser, this.userACL_.getMakableMT());
            if (groups != null && groups.size() > 0) {
                if (withSite) {
                    for (Group group : groups) {
                        PortalConfig cfg = this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, group.getId());
                        if (cfg == null) continue;
                        hasNav = true;
                        break;
                    }
                } else {
                    hasNav = true;
                }
            }
        }
        return hasNav;
    }

    public void createUserSite(String userName) throws Exception {
        SiteKey key;
        NavigationContext nav;
        this.createUserPortalConfig(PortalConfig.USER_TYPE, userName, this.getDefaultUserSiteTemplate());
        PortalConfig cfg = this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, userName);
        if (cfg == null) {
            cfg = new PortalConfig(PortalConfig.USER_TYPE, userName);
            cfg.useMetaPortalLayout();
            this.layoutService.create(cfg);
        }
        if ((nav = this.navigationService.loadNavigation(key = SiteKey.user((String)userName))) == null) {
            nav = new NavigationContext(key, new NavigationState(Integer.valueOf(5)));
            this.navigationService.saveNavigation(nav);
        }
    }

    public void createGroupSite(String groupId) throws Exception {
        this.createUserPortalConfig(PortalConfig.GROUP_TYPE, groupId, this.getDefaultGroupSiteTemplate());
        PortalConfig cfg = this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, groupId);
        if (cfg == null) {
            cfg = new PortalConfig(PortalConfig.GROUP_TYPE, groupId);
            cfg.useMetaPortalLayout();
            this.layoutService.create(cfg);
        }
    }

    public void createUserPortalConfig(String siteType, String siteName, String template) throws Exception {
        NewPortalConfig portalConfig = null;
        if (StringUtils.isBlank((String)template)) {
            portalConfig = new NewPortalConfig();
            portalConfig.setUseMetaPortalLayout(true);
        } else {
            String templatePath = this.newPortalConfigListener_.getTemplateConfig(siteType, template);
            portalConfig = new NewPortalConfig(templatePath);
            portalConfig.setTemplateName(template);
        }
        portalConfig.setOwnerType(siteType);
        this.newPortalConfigListener_.createPortalConfig(portalConfig, siteName);
        this.newPortalConfigListener_.createPage(portalConfig, siteName);
        this.newPortalConfigListener_.createPageNavigation(portalConfig, siteName);
    }

    public void removeUserPortalConfig(String portalName) throws Exception {
        this.removeUserPortalConfig(PortalConfig.PORTAL_TYPE, portalName);
    }

    public void removeUserPortalConfig(String ownerType, String ownerId) throws Exception {
        PortalConfig config = this.layoutService.getPortalConfig(ownerType, ownerId);
        if (config != null) {
            this.layoutService.remove(config);
        }
    }

    public PageContext getPage(PageKey pageRef) {
        if (pageRef == null) {
            return null;
        }
        PageContext page = this.layoutService.getPageContext(pageRef);
        if (page == null || !this.userACL_.hasPermission(page)) {
            return null;
        }
        return page;
    }

    public Page createPageTemplate(String temp, String ownerType, String ownerId) throws Exception {
        Page page = this.newPortalConfigListener_.createPageFromTemplate(ownerType, ownerId, temp);
        this.updateOwnership((ModelObject)page, ownerType, ownerId);
        return page;
    }

    public String getGlobalPortal() {
        return this.globalPortal_;
    }

    public List<String> getSiteNames(SiteType siteType, int offset, int limit) {
        List list = this.layoutService.getSiteNames(siteType, offset, limit);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (siteType == SiteType.PORTAL && StringUtils.equals((String)name, (String)this.globalPortal_)) {
                i.remove();
                continue;
            }
            PortalConfig config = this.layoutService.getPortalConfig(siteType.getName(), name);
            if (config != null && this.userACL_.hasPermission(config)) continue;
            i.remove();
        }
        return list;
    }

    public List<PortalConfig> getUserPortalSites() {
        List list = this.layoutService.getSites(this.siteFilter);
        return list.stream().filter(Objects::nonNull).filter(this.userACL_::hasPermission).sorted((s1, s2) -> {
            if (!s2.isDisplayed() && !s1.isDisplayed()) {
                if (StringUtils.equals((String)s1.getName(), (String)PUBLIC_SITE_NAME)) {
                    return -1;
                }
                if (StringUtils.equals((String)s2.getName(), (String)PUBLIC_SITE_NAME)) {
                    return 1;
                }
                return s2.getName().compareTo(s1.getName());
            }
            if (!s2.isDisplayed()) {
                return -2147483647;
            }
            if (!s1.isDisplayed()) {
                return Integer.MAX_VALUE;
            }
            int order = s1.getDisplayOrder() - s2.getDisplayOrder();
            return order == 0 ? s2.getName().compareTo(s1.getName()) : order;
        }).toList();
    }

    public String computePortalSitePath(String portalName, HttpServletRequest context) throws Exception {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(portalName);
        if (portalConfig == null) {
            return null;
        }
        Collection<UserNode> userNodes = this.getPortalSiteNavigations(portalName, SiteType.PORTAL.getName(), context);
        UserNode userNode = this.getFirstAllowedPageNode(userNodes);
        if (userNode == null) {
            return null;
        }
        return this.getDefaultUri(userNode, portalName);
    }

    public String computePortalPath(HttpServletRequest context) throws Exception {
        List<PortalConfig> portalConfigList = this.getUserPortalSites();
        if (CollectionUtils.isEmpty(portalConfigList)) {
            return null;
        }
        String portalPath = null;
        Iterator iterator = portalConfigList.stream().iterator();
        while (portalPath == null && iterator.hasNext()) {
            portalPath = this.computePortalSitePath(((PortalConfig)iterator.next()).getName(), context);
        }
        return portalPath;
    }

    public Collection<UserNode> getPortalSiteNavigations(String siteName, String portalType, HttpServletRequest context) throws Exception {
        HttpUserPortalContext userPortalContext = new HttpUserPortalContext(context);
        UserPortalConfig userPortalConfig = this.getUserPortalConfig(siteName, context.getRemoteUser(), userPortalContext);
        if (userPortalConfig == null) {
            return Collections.emptyList();
        }
        UserPortal userPortal = userPortalConfig.getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(new SiteKey(SiteType.valueOf((String)portalType.toUpperCase()), siteName));
        UserNodeFilterConfig builder = UserNodeFilterConfig.builder().withReadWriteCheck().withVisibility(Visibility.DISPLAYED, Visibility.TEMPORAL).withTemporalCheck().build();
        UserNode rootNode = userPortal.getNode(navigation, org.exoplatform.portal.mop.navigation.Scope.ALL, builder, null);
        return rootNode != null ? rootNode.getChildren() : Collections.emptyList();
    }

    public UserNode getPortalSiteRootNode(String siteName, String siteType, HttpServletRequest context) throws Exception {
        HttpUserPortalContext userPortalContext = new HttpUserPortalContext(context);
        UserPortalConfig userPortalConfig = this.getUserPortalConfig(siteName, context.getRemoteUser(), userPortalContext);
        if (userPortalConfig == null) {
            return null;
        }
        UserPortal userPortal = userPortalConfig.getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(new SiteKey(SiteType.valueOf((String)siteType.toUpperCase()), siteName));
        UserNodeFilterConfig builder = UserNodeFilterConfig.builder().withReadWriteCheck().withVisibility(Visibility.DISPLAYED, Visibility.TEMPORAL).withTemporalCheck().build();
        return userPortal.getNode(navigation, org.exoplatform.portal.mop.navigation.Scope.ALL, builder, null);
    }

    public UserNode getFirstAllowedPageNode(Collection<UserNode> userNodes) {
        UserNode userNode = null;
        for (UserNode node : userNodes) {
            if (node.getPageRef() != null) {
                userNode = node;
                break;
            }
            if (node.getChildren() != null && !node.getChildren().isEmpty()) {
                userNode = this.getFirstAllowedPageNode(node.getChildren());
            }
            if (userNode == null) continue;
            break;
        }
        return userNode;
    }

    public String getFirstAllowedPageNode(String portalName, String portalType, String nodePath, HttpServletRequest context) throws Exception {
        UserNode targetUserNode = this.getPortalSiteRootNode(portalName, portalType, context);
        if (targetUserNode == null) {
            return nodePath;
        }
        String[] pathNodesNames = nodePath.split("/");
        Iterator iterator = Arrays.stream(pathNodesNames).iterator();
        while (iterator.hasNext() && targetUserNode != null) {
            targetUserNode = targetUserNode.getChild((String)iterator.next());
        }
        if (targetUserNode == null) {
            return nodePath;
        }
        String newPath = null;
        while (newPath == null) {
            if (targetUserNode.getPageRef() != null) {
                newPath = targetUserNode.getURI();
                continue;
            }
            if (!targetUserNode.getChildren().isEmpty()) {
                targetUserNode = this.getFirstAllowedPageNode(targetUserNode.getChildren());
                continue;
            }
            targetUserNode = targetUserNode.getParent();
        }
        return newPath;
    }

    private void updateOwnership(ModelObject object, String ownerType, String ownerId) {
        Application application;
        TransientApplicationState applicationState;
        if (object instanceof Container) {
            Container container = (Container)object;
            if (container instanceof Page) {
                Page page = (Page)container;
                page.setOwnerType(ownerType);
                page.setOwnerId(ownerId);
            }
            for (ModelObject child : container.getChildren()) {
                this.updateOwnership(child, ownerType, ownerId);
            }
        } else if (object instanceof Application && (applicationState = (TransientApplicationState)(application = (Application)object).getState()) != null && (applicationState.getOwnerType() == null || applicationState.getOwnerId() == null)) {
            applicationState.setOwnerType(ownerType);
            applicationState.setOwnerId(ownerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initListener(ComponentPlugin listener) {
        if (listener instanceof NewPortalConfigListener) {
            UserPortalConfigService userPortalConfigService = this;
            synchronized (userPortalConfigService) {
                if (this.newPortalConfigListener_ == null) {
                    this.newPortalConfigListener_ = (NewPortalConfigListener)listener;
                } else {
                    this.newPortalConfigListener_.mergePlugin((NewPortalConfigListener)listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteListenerElements(ComponentPlugin listener) {
        if (listener instanceof NewPortalConfigListener) {
            UserPortalConfigService userPortalConfigService = this;
            synchronized (userPortalConfigService) {
                if (this.newPortalConfigListener_ != null) {
                    this.newPortalConfigListener_.deleteListenerElements((NewPortalConfigListener)listener);
                }
            }
        }
    }

    public void start() {
        try {
            if (this.newPortalConfigListener_ == null) {
                return;
            }
            this.newPortalConfigListener_.run();
        }
        catch (Exception e) {
            this.log.error((Object)"Could not import initial data", (Throwable)e);
        }
        this.loadMetaPortalConfig();
    }

    public void stop() {
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public String getDefaultPortal() {
        return this.newPortalConfigListener_.getDefaultPortal();
    }

    public String getMetaPortal() {
        return this.newPortalConfigListener_.getMetaPortal();
    }

    public String getUserHomePage(String username) {
        if (StringUtils.isBlank((String)username)) {
            return null;
        }
        SettingValue homePageSettingValue = this.settingService.get(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        if (homePageSettingValue != null && homePageSettingValue.getValue() != null) {
            return homePageSettingValue.getValue().toString();
        }
        return PropertyManager.getProperty((String)"exo.portal.user.defaultHome");
    }

    public void saveUserHomePage(String username, String uri) {
        if (StringUtils.isBlank((String)uri)) {
            this.settingService.remove(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        } else {
            this.settingService.set(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY, SettingValue.create((String)uri));
        }
    }

    public String getDefaultPortalTemplate() {
        return this.newPortalConfigListener_.getDefaultPortalTemplate();
    }

    public Set<String> getPortalTemplates() {
        return this.newPortalConfigListener_.getTemplateConfigs(PortalConfig.PORTAL_TYPE);
    }

    public PortalConfig getPortalConfigFromTemplate(String templateName) {
        return this.newPortalConfigListener_.getPortalConfigFromTemplate(PortalConfig.PORTAL_TYPE, templateName);
    }

    public <T> T getConfig(String portalType, String portalName, Class<T> objectType, String parentLocation) {
        return this.newPortalConfigListener_.getConfig(portalType, portalName, objectType, parentLocation);
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public String getDefaultPortalSkinName() {
        return this.getMetaPortalSkinName();
    }

    public String getMetaPortalSkinName() {
        return this.metaPortalConfig != null && StringUtils.isNotBlank((String)this.metaPortalConfig.getSkin()) ? this.metaPortalConfig.getSkin() : null;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public PortalConfig getDefaultPortalConfig() {
        return this.getMetaPortalConfig();
    }

    public PortalConfig getMetaPortalConfig() {
        return this.metaPortalConfig;
    }

    public void setMetaPortalConfig(PortalConfig metaPortalConfig) {
        this.metaPortalConfig = metaPortalConfig;
    }

    private void loadMetaPortalConfig() {
        String metaPortal = this.getMetaPortal();
        if (metaPortal != null) {
            try {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                this.metaPortalConfig = this.getDataStorage().getPortalConfig(metaPortal);
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot retrieve data of portal " + metaPortal), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void reloadConfig(String ownerType, String predefinedOwner, String location, String importMode, boolean overrideMode) {
        this.newPortalConfigListener_.reloadConfig(ownerType, predefinedOwner, location, importMode, overrideMode);
    }

    private String getDefaultUri(UserNode node, String site) {
        Object uri = "/portal/" + site + "/";
        Page userNodePage = this.layoutService.getPage(node.getPageRef());
        uri = PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType())) ? userNodePage.getLink() : (String)uri + node.getURI();
        return uri;
    }
}

