/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class ColDataType {
    private String dataType;
    private List<String> argumentsStringList;
    private String characterSet;
    private List<Integer> arrayData = new ArrayList<Integer>();

    public ColDataType() {
    }

    public ColDataType(String string) {
        this.dataType = string;
    }

    public List<String> getArgumentsStringList() {
        return this.argumentsStringList;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setArgumentsStringList(List<String> list) {
        this.argumentsStringList = list;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public void setDataType(List<String> list) {
        this.dataType = list.stream().collect(Collectors.joining("."));
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String string) {
        this.characterSet = string;
    }

    public List<Integer> getArrayData() {
        return this.arrayData;
    }

    public void setArrayData(List<Integer> list) {
        this.arrayData = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n2 : this.arrayData) {
            stringBuilder.append("[");
            if (n2 != null) {
                stringBuilder.append(n2);
            }
            stringBuilder.append("]");
        }
        return this.dataType + (this.argumentsStringList != null ? " " + PlainSelect.getStringList(this.argumentsStringList, true, true) : "") + stringBuilder.toString() + (this.characterSet != null ? " CHARACTER SET " + this.characterSet : "");
    }

    public ColDataType withDataType(String string) {
        this.setDataType(string);
        return this;
    }

    public ColDataType withArgumentsStringList(List<String> list) {
        this.setArgumentsStringList(list);
        return this;
    }

    public ColDataType withCharacterSet(String string) {
        this.setCharacterSet(string);
        return this;
    }

    public ColDataType withArrayData(List<Integer> list) {
        this.setArrayData(list);
        return this;
    }

    public ColDataType addArgumentsStringList(String ... stringArray) {
        List list = Optional.ofNullable(this.getArgumentsStringList()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withArgumentsStringList(list);
    }

    public ColDataType addArgumentsStringList(Collection<String> collection) {
        List list = Optional.ofNullable(this.getArgumentsStringList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withArgumentsStringList(list);
    }

    public ColDataType addArrayData(Integer ... integerArray) {
        List list = Optional.ofNullable(this.getArrayData()).orElseGet(ArrayList::new);
        Collections.addAll(list, integerArray);
        return this.withArrayData(list);
    }

    public ColDataType addArrayData(Collection<Integer> collection) {
        List list = Optional.ofNullable(this.getArrayData()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withArrayData(list);
    }
}

