/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

public abstract class AbstractQueryBuilder {
    protected StringBuilder fromClause = new StringBuilder();
    protected StringBuilder propertiesClause = new StringBuilder();
    protected StringBuilder pathClause = new StringBuilder();
    protected StringBuilder orderByClause = new StringBuilder();
    protected StringBuilder selectClause = new StringBuilder();
    protected StringBuilder containsClause = new StringBuilder();
    protected StringBuilder spellCheckClause = new StringBuilder();
    protected StringBuilder excerptClause = new StringBuilder();

    public abstract void isNull(String var1, LOGICAL var2);

    public abstract void isNotNull(String var1, LOGICAL var2);

    public abstract void lessThan(String var1, String var2, LOGICAL var3);

    public abstract void greaterThan(String var1, String var2, LOGICAL var3);

    public abstract void lessThanOrEqual(String var1, String var2, LOGICAL var3);

    public abstract void greaterOrEqual(String var1, String var2, LOGICAL var3);

    public abstract void equal(String var1, String var2, LOGICAL var3);

    public abstract void notEqual(String var1, String var2, LOGICAL var3);

    public abstract void like(String var1, String var2, LOGICAL var3);

    public abstract void reference(String var1, String var2, LOGICAL var3);

    public abstract void beforeDate(String var1, String var2, LOGICAL var3);

    public abstract void afterDate(String var1, String var2, LOGICAL var3);

    public abstract void betweenDates(String var1, String var2, String var3, LOGICAL var4);

    public abstract void setQueryPath(String var1, PATH_TYPE var2);

    public abstract void contains(String var1, String var2, LOGICAL var3);

    public abstract void notContains(String var1, String var2, LOGICAL var3);

    public abstract void excerpt(boolean var1);

    public abstract void spellCheck(String var1);

    public abstract void orderBy(String var1, ORDERBY var2);

    public abstract void selectTypes(String[] var1);

    public abstract void fromNodeTypes(String[] var1);

    public abstract void openGroup(LOGICAL var1);

    public abstract void closeGroup();

    public abstract String createQueryStatement();

    public abstract void merge(AbstractQueryBuilder var1);

    public static enum COMPARISON_TYPE {
        EQUAL,
        LIKE;

    }

    public static enum ORDERBY {
        ASC,
        DESC;

    }

    public static enum LOGICAL {
        AND,
        OR,
        NULL,
        NOT,
        AND_NOT,
        OR_NOT;

    }

    public static enum PATH_TYPE {
        EXACT,
        CHILDNODES,
        DECENDANTS,
        DECENDANTS_OR_SELFT;

    }

    public static class QueryTermHelper {
        private String term = "";

        public QueryTermHelper contains(String s) {
            this.term = this.term.concat(s);
            return this;
        }

        public QueryTermHelper notContains(String s) {
            this.term = s.indexOf(" ") > 0 ? this.term.concat("-\\" + s + "\\") : this.term.concat("-" + s);
            return this;
        }

        public String buildTerm() {
            return this.term;
        }

        public QueryTermHelper allowFuzzySearch(double fuzzySearchIndex) {
            this.term = this.term.concat("~").concat(String.valueOf(fuzzySearchIndex));
            return this;
        }

        public QueryTermHelper allowSynonymSearch() {
            this.term = "~".concat(this.term);
            return this;
        }
    }
}

