/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.linkedin;

import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.linkedin.LinkedinAccessTokenContext;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.web.OAuthProviderFilter;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class LinkedInFilter
extends OAuthProviderFilter<LinkedinAccessTokenContext> {
    private static String URL_CURRENT_PROFILE_USER = "https://api.linkedin.com/v2/userinfo";
    private static String URL_CURRENT_PROFILE_USER_EMAIL = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";

    @Override
    protected OAuthProviderType<LinkedinAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("LINKEDIN", LinkedinAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_linkedinRequestToken");
    }

    @Override
    protected OAuthPrincipal<LinkedinAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<LinkedinAccessTokenContext> interactionState) {
        LinkedinAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
        OAuthRequest oauthRequest = new OAuthRequest(Verb.GET, URL_CURRENT_PROFILE_USER);
        accessTokenContext.oauth20Service.signRequest(accessTokenContext.accessToken, oauthRequest);
        try {
            Response responses = accessTokenContext.oauth20Service.execute(oauthRequest);
            String body = responses.getBody();
            JSONObject json = new JSONObject(body);
            String firstName = json.getString("given_name");
            String lastName = json.getString("family_name");
            String displayName = json.getString("name");
            String email = json.getString("email");
            String avatar = json.getString("picture");
            OAuthPrincipal<LinkedinAccessTokenContext> principal = new OAuthPrincipal<LinkedinAccessTokenContext>(null, firstName, lastName, displayName, email, avatar, accessTokenContext, this.getOAuthProvider());
            return principal;
        }
        catch (IOException | InterruptedException | ExecutionException | JSONException ex) {
            throw new OAuthException(OAuthExceptionCode.LINKEDIN_ERROR, "Error when obtaining user", ex);
        }
    }
}

