/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import org.infinispan.commons.util.concurrent.jdk8backported.BoundedEquivalentConcurrentHashMapV8;
import org.infinispan.commons.util.concurrent.jdk8backported.EntrySizeCalculator;
import org.infinispan.commons.util.concurrent.jdk8backported.EvictionPolicy;
import org.infinispan.commons.util.concurrent.jdk8backported.LIRSEvictionPolicy;
import org.infinispan.commons.util.concurrent.jdk8backported.LRUEvictionPolicy;
import org.infinispan.commons.util.concurrent.jdk8backported.NodeSizeCalculatorWrapper;
import org.infinispan.commons.util.concurrent.jdk8backported.NullEvictionPolicy;
import org.infinispan.commons.util.concurrent.jdk8backported.SingleEntrySizeCalculator;

public enum Eviction {
    NONE{

        @Override
        public <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> map, EntrySizeCalculator<? super K, ? super V> sizeCalculator, long capacity) {
            return new NullEvictionPolicy(map.nodeEq);
        }
    }
    ,
    LRU{

        @Override
        public <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> map, EntrySizeCalculator<? super K, ? super V> sizeCalculator, long capacity) {
            if (sizeCalculator == null) {
                return new LRUEvictionPolicy<Object, Object>(map, capacity, SingleEntrySizeCalculator.SINGLETON, false);
            }
            return new LRUEvictionPolicy<K, V>(map, capacity, new NodeSizeCalculatorWrapper<K, V>(sizeCalculator), true);
        }
    }
    ,
    LIRS{

        @Override
        public <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> map, EntrySizeCalculator<? super K, ? super V> sizeCalculator, long capacity) {
            if (sizeCalculator != null) {
                throw new IllegalArgumentException("LIRS does not support a size calculator!");
            }
            return new LIRSEvictionPolicy<K, V>(map, capacity);
        }
    };


    abstract <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> var1, EntrySizeCalculator<? super K, ? super V> var2, long var3);
}

